<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require __DIR__ . '/phpmailer/PHPMailer.php';
require __DIR__ . '/phpmailer/SMTP.php';
require __DIR__ . '/phpmailer/Exception.php';

function sendVerificationMail($toEmail, $toName, $verifyLink)
{
    $mail = new PHPMailer(true);

    try {

        /* ===============================
           SMTP AYARLARI
        ================================= */
        $mail->isSMTP();
        $mail->Host       = 'mail.novapus.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'no-reply@novapus.com';
        $mail->Password   = 'Pars@4650';  // cPanel şifren
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;

        /* ===============================
           TÜRKÇE KARAKTER DESTEĞİ
        ================================= */
        $mail->CharSet = 'UTF-8';
        $mail->Encoding = 'base64';

        /* ===============================
           GÖNDEREN ve ALICI
        ================================= */
        $mail->setFrom('no-reply@novapus.com', 'Novapus');
        $mail->addAddress($toEmail, $toName);

        /* ===============================
           LOGO’YU MAIL İÇİNE GÖMME (CID)
        ================================= */
        $logoPath = __DIR__ . '/../assets/img/logo-3d.png';
        if (file_exists($logoPath)) {
            $mail->AddEmbeddedImage($logoPath, 'novalogo', 'logo-3d.png');
        }

        /* ===============================
           MAİL İÇERİĞİ
        ================================= */
        $mail->isHTML(true);
        $mail->Subject = 'Novapus Hesap Doğrulama';

        // HTML TEMPLATE
        $mail->Body = '
        <html>
        <body style="margin:0; padding:0; background:#0a0f1a; font-family:Arial, Helvetica, sans-serif;">

        <div style="max-width:520px; margin:40px auto; background:#111726; border-radius:12px;
                    overflow:hidden; box-shadow:0 0 25px rgba(0,0,0,0.45);">

            <div style="background: radial-gradient(circle at center, #1f2b48 0%, #0a0f1a 100%);
                        padding:30px 20px; text-align:center;">
                <img src="cid:novalogo" width="180" alt="Novapus Logo"
                     style="display:block; margin:auto; filter: drop-shadow(0 0 12px #4db8ff);">

                <h2 style="color:#ffffff; margin-top:20px; font-size:24px; letter-spacing:0.5px;">
                    Novapus Hesabını Doğrula
                </h2>
            </div>

            <div style="padding:25px 30px; color:#d6d6d6; font-size:15px; line-height:1.7;">
                <p>Merhaba Komutan <strong>' . htmlspecialchars($toName) . '</strong>,</p>

                <p>
                    Novapus galaksisine giriş yapmak üzeresin.<br>
                    Hesabını aktifleştirmek için aşağıdaki doğrulama
                    bağlantısına tıklaman yeterlidir:
                </p>

                <div style="text-align:center; margin:35px 0;">
                    <a href="' . $verifyLink . '"
                       style="background:#3d7cff; padding:14px 26px; color:white; text-decoration:none;
                              font-size:16px; border-radius:8px;
                              box-shadow:0 0 15px rgba(61,124,255,0.6);
                              display:inline-block;">
                        Hesabımı Doğrula
                    </a>
                </div>

                <p>
                    Eğer bu işlemi sen yapmadıysan bu e-postayı dikkate alma.
                </p>
            </div>

            <div style="background:#0c1320; padding:18px; text-align:center;
                        font-size:12px; color:#6f7a93;">
                © 2025 Novapus • Uzayın Derinliklerine Yolculuk
            </div>

        </div>

        </body>
        </html>
        ';

        return $mail->send();

    } catch (Exception $e) {
        return false;
    }
}
