<?php
// portal/includes/universe_list_block.php

// Eğer $db yoksa güvenli şekilde oluştur
if (!isset($db) || !($db instanceof PDO)) {
    require_once __DIR__ . '/db.php';
    $db = DB::get();
}

// Basit evren listesi çekelim
// portal_universes tablosunda en azından: id, name, status alanları olduğunu varsayıyoruz
$stmt = $db->query("SELECT id, name, status FROM portal_universes ORDER BY id ASC");
$universes = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="universes-preview">
    <div class="section-header">
        <div class="section-eyebrow">EVREN SEÇİMİ</div>
        <h2>Aktif Evrenler</h2>
        <p>Tarzına uygun evreni seç, filonu hazırla ve galaktik yarışa hemen başla.</p>
    </div>

    <div class="universe-list">
        <?php if (empty($universes)): ?>

            <p>Şu anda tanımlı evren bulunmuyor. Admin panelden <strong>Evrenler</strong> bölümünden ekleyebilirsin.</p>

        <?php else: ?>
            <?php foreach ($universes as $u): ?>
                <?php
                    $isActive = ($u['status'] === 'active');
                ?>
                <article class="universe-card <?= $isActive ? 'universe-card-primary' : 'universe-card-secondary' ?>">
                    <div class="universe-glow <?= $isActive ? '' : 'glow-secondary' ?>"></div>

                    <header class="universe-header">
                        <div>
                            <h3><?= htmlspecialchars($u['name']); ?></h3>
                            <div class="universe-subtitle">
                                <?= $isActive ? 'Aktif · Oynamaya hazır' : 'Yakında açılacak' ?>
                            </div>
                        </div>
                        <span class="badge <?= $isActive ? 'badge-live' : 'badge-soon' ?>">
                            <?= $isActive ? 'Aktif' : 'Yakında' ?>
                        </span>
                    </header>

                    <p class="universe-desc">
                        <?= $isActive
                            ? 'Filonu hazırlayıp hemen bu evrende mücadeleye başlayabilirsin.'
                            : 'Açılış tarihi yakında duyurulacak. Erken kayıt avantajlarını kaçırma.' ?>
                    </p>

                    <div class="universe-meta-row">
                        <?php if ($isActive): ?>
                            <span class="universe-pill">Aktif oyuncu topluluğu</span>
                            <span class="universe-dot-live">Canlı savaşlar</span>
                        <?php else: ?>
                            <span class="universe-pill universe-pill-soon">Hazırlık aşamasında</span>
                        <?php endif; ?>
                    </div>

                    <div class="universe-actions">
                        <?php if ($isActive): ?>
                            <a href="index.php?page=login" class="btn btn-primary btn-universe">
                                Bu evrende oyna
                            </a>
                        <?php else: ?>
                            <button class="btn btn-disabled btn-universe" disabled>
                                Yakında
                            </button>
                        <?php endif; ?>
                    </div>
                </article>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>
