<?php
// portal/pages/home.php
require_once __DIR__ . '/../includes/db.php';

$db = DB::get();

// Görünür blokları sıraya göre çek
$stmt   = $db->query("SELECT * FROM portal_cms WHERE visible = 1 ORDER BY sort ASC, id ASC");
$blocks = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<?php if (empty($blocks)): ?>

    <section class="cms-block-section">
        <div style="padding:40px 20px; text-align:center; color:#9ca3af;">
            Henüz tanımlanmış bir portal içeriği yok. Admin panelden <strong>Portal CMS</strong> üzerinden blok ekleyin.
        </div>
    </section>

<?php else: ?>

    <?php foreach ($blocks as $b): ?>
        <?php
            $type = $b['type'] ?? 'html';
            $slug = $b['slug'];
        ?>

        <section
            class="cms-block-section cms-type-<?= htmlspecialchars($type) ?>"
            id="cms_<?= htmlspecialchars($slug) ?>"
        >

            <?php
            // Opsiyonel: blok görseli varsa üstte göster
            if (!empty($b['image'])): ?>
                <div class="cms-block-image">
                    <img src="<?= htmlspecialchars($b['image']); ?>" alt="" />
                </div>
            <?php endif; ?>

            <?php
            // Tip bazlı modül davranışı
            switch ($type) {
                case 'hero':
                    // Hero tipinde içeriği özel bir wrapper ile sar
                    echo '<div class="cms-hero-wrapper">';
                    echo $b['content']; // CKEditor ile tasarladığın hero HTML’i
                    echo '</div>';
                    break;

                case 'universes':
                    // Evren modülü – ayrı PHP bloğundan çiz
                    $path = __DIR__ . '/../includes/universe_list_block.php';
                    if (file_exists($path)) {
                        // universe_list_block.php içinde $db kullanacağız
                        include $path;
                    } else {
                        // Dosya yoksa içeriği olduğu gibi bas
                        echo $b['content'];
                    }
                    break;

                case 'slider':
                    // Slider modülü – HTML içeriğini özel wrapper içine al
                    echo '<div class="cms-slider">';
                    echo $b['content']; // CKEditor içinde <div class="slide">...</div> yapabilirsin
                    echo '</div>';
                    break;

                case 'banner':
                    echo '<div class="cms-banner">';
                    echo $b['content'];
                    echo '</div>';
                    break;

                case 'text':
                    echo '<div class="cms-text-block">';
                    echo $b['content'];
                    echo '</div>';
                    break;

                case 'html':
                default:
                    // Standart HTML – direk bas
                    echo $b['content'];
                    break;
            }
            ?>

        </section>

    <?php endforeach; ?>

<?php endif; ?>
