<?php
// portal/pages/play.php

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../config.php';

// index.php zaten session_start yapıyor ama emin olalım:
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Portal oturumu var mı?
if (empty($_SESSION['portal_user'])) {
    header("Location: index.php?page=login");
    exit;
}

$portalUser   = $_SESSION['portal_user'];
$portalUserId = (int)$portalUser['id'];

$db = DB::get();

// URL'den evren ID'si
$universeId = isset($_GET['universe']) ? (int)$_GET['universe'] : 0;
if ($universeId <= 0) {
    die("Geçersiz evren.");
}

// Evren bilgilerini al
$stmt = $db->prepare("SELECT * FROM portal_universes WHERE id = ?");
$stmt->execute([$universeId]);
$universe = $stmt->fetch();

if (!$universe) {
    die("Evren bulunamadı.");
}

// Oyun veritabanı adı (ör: novapus_steem)
$gameDBName = $universe['db_name'];
if (empty($gameDBName)) {
    die("Evren için oyun veritabanı adı (db_name) tanımlanmamış.");
}

// ===============================
//  OYUN VERİTABANINA BAĞLAN
//  (HER DURUMDA GEREKECEK)
// ===============================
$dsn = "mysql:host=" . DB_HOST . ";dbname=" . $gameDBName . ";charset=utf8mb4;port=" . DB_PORT;

try {
    $gameDB = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (Exception $e) {
    die("Oyun veritabanına bağlanılamadı: " . $e->getMessage());
}

$tableUsers   = "uni1_users";    // SteemNova user tablosu
$tablePlanets = "uni1_planets";  // SteemNova planets tablosu

// Bu evrende daha önce hesap açılmış mı?
$stmt = $db->prepare("
    SELECT * FROM portal_user_universe_accounts
    WHERE portal_user_id = ? AND universe_id = ?
");
$stmt->execute([$portalUserId, $universeId]);
$account = $stmt->fetch();

$gameUserId = null;

// ====================================
// 1) Hesap yoksa: kullanıcı + gezegen
// ====================================
if (!$account) {

    $username   = $portalUser['username'];
    $email      = $portalUser['email'];
    $ip         = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
    $timezone   = "Europe/London";

    // Oyun için rastgele şifre (kullanıcı bunu bilmeyecek)
    $passwordRaw  = bin2hex(random_bytes(10));
    $passwordHash = sha1($passwordRaw); // SteemNova sha1 formatı

    // ---- users insert ----
    $stmtUser = $gameDB->prepare("
        INSERT INTO {$tableUsers}
        (username, password, email, email_2, lang, authlevel, rights,
         galaxy, system, planet, universe,
         user_lastip, ip_at_reg, register_time, onlinetime, timezone)
        VALUES
        (?, ?, ?, '', 'tr', 0, '',
         1, 1, 1, 1,
         ?, ?, UNIX_TIMESTAMP(), UNIX_TIMESTAMP(), ?)
    ");

    $stmtUser->execute([
        $username,
        $passwordHash,
        $email,
        $ip,
        $ip,
        $timezone
    ]);

    $gameUserId = (int)$gameDB->lastInsertId();

    // -------- BAŞLANGIÇ GEZEGENİ OLUŞTUR -------- //
    $galaxy = 1;
    $system = rand(1, 250);
    $planet = rand(1, 15);

    $planetName = $username . "'in Gezegeni";

    $stmtPlanet = $gameDB->prepare("
        INSERT INTO {$tablePlanets}
        (name, id_owner, universe, galaxy, system, planet, planet_type, last_update, image)
        VALUES
        (?, ?, 1, ?, ?, ?, 1, UNIX_TIMESTAMP(), 'normaltempplanet01')
    ");

    $stmtPlanet->execute([
        $planetName,
        $gameUserId,
        $galaxy,
        $system,
        $planet
    ]);

    $planetId = (int)$gameDB->lastInsertId();

    // ---- Kullanıcının planet_id kolonunu güncelle ----
    $stmtUpdateUser = $gameDB->prepare("
        UPDATE {$tableUsers}
        SET id_planet = ?
        WHERE id = ?
    ");
    $stmtUpdateUser->execute([
        $planetId,
        $gameUserId
    ]);

    // ---- Portal tarafında ilişki kaydı oluştur ----
    $stmt = $db->prepare("
        INSERT INTO portal_user_universe_accounts (portal_user_id, universe_id, game_user_id)
        VALUES (?, ?, ?)
    ");
    $stmt->execute([$portalUserId, $universeId, $gameUserId]);

} else {
    // Hesap zaten varsa sadece game_user_id'yi kullan
    $gameUserId = (int)$account['game_user_id'];
}

// ===============================
// 2) SSO TOKEN OLUŞTUR
//    (Oyun DB'sine yazılacak)
// ===============================
$token = bin2hex(random_bytes(32));

$stmtToken = $gameDB->prepare("
    INSERT INTO portal_login_tokens (token, portal_user_id, universe_id, game_user_id, created_at)
    VALUES (?, ?, ?, ?, NOW())
");
$stmtToken->execute([$token, $portalUserId, $universeId, $gameUserId]);

// ===============================
// 3) Kullanıcıyı oyun evrenine yönlendir
// ===============================
$baseUrl  = rtrim($universe['base_url'], '/'); // ör: https://uni1.novapus.com
$loginURL = $baseUrl . "/sso-login.php?token=" . urlencode($token);

header("Location: " . $loginURL);
exit;
