<?php
// /portal/pages/support_view.php

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';

if (!isset($_SESSION['portal_user'])) {
    echo "<p>Giriş yapmalısın.</p>";
    exit;
}

$db   = DB::get();
$user = $_SESSION['portal_user'];

$ticketId = intval($_GET['id'] ?? 0);

if ($ticketId <= 0) {
    echo "<p>Geçersiz ticket.</p>";
    exit;
}

/* =============================================
   TICKET BİLGİLERİ
============================================= */
$stm = $db->prepare("SELECT * FROM portal_tickets WHERE id = ? AND user_id = ?");
$stm->execute([$ticketId, $user['id']]);
$ticket = $stm->fetch();

if (!$ticket) {
    echo "<p>Ticket bulunamadı.</p>";
    exit;
}

/* =============================================
   POST İŞLEMLERİ (redirect YOK → header hatası da YOK)
============================================= */
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Ticket kapatma
    if (isset($_POST['close_ticket']) && $ticket['status'] !== 'closed') {
        $db->prepare("
            UPDATE portal_tickets 
            SET status = 'closed', updated_at = NOW() 
            WHERE id = ?
        ")->execute([$ticketId]);

        // ticket nesnesini güncelle
        $ticket['status']     = 'Kapalı';
        $ticket['updated_at'] = date('d-m-Y - H:i:s');
    }

    // Mesaj gönderme
    if (isset($_POST['send_message']) && $ticket['status'] !== 'closed') {
        $msg = trim($_POST['message'] ?? '');

        if ($msg !== '') {
            $stmt = $db->prepare("
                INSERT INTO portal_ticket_messages (ticket_id, sender, message, created_at)
                VALUES (?, 'user', ?, NOW())
            ");
            $stmt->execute([$ticketId, $msg]);

            $db->prepare("
                UPDATE portal_tickets 
                SET updated_at = NOW(), status = 'open' 
                WHERE id = ?
            ")->execute([$ticketId]);

            $ticket['status']     = 'Açık';
            $ticket['updated_at'] = date('d.m.Y - H:i:s');
        }
    }
}

/* =============================================
   MESAJLAR + EKLER
============================================= */
$msgStmt = $db->prepare("
    SELECT * FROM portal_ticket_messages 
    WHERE ticket_id = ? 
    ORDER BY id ASC
");
$msgStmt->execute([$ticketId]);
$messages = $msgStmt->fetchAll();

$attStmt = $db->prepare("
    SELECT * FROM portal_ticket_attachments 
    WHERE ticket_id = ?
");
$attStmt->execute([$ticketId]);
$attachments = $attStmt->fetchAll();
?>

<style>
.ticket-page-wrap{
    max-width: 960px;
    margin: 0 auto;
}

/* Üst kart */
.ticket-card {
    background: #020617;
    border: 1px solid #1e293b;
    border-radius: 8px;
    padding: 18px;
    margin-bottom: 16px;
    color: #e2e8f0;
}

/* Chat kartı */
.ticket-chat-card{
    background: #020617;
    border: 1px solid #1e293b;
    border-radius: 8px;
    padding: 18px;
}

/* Chat alanı */
.chat-box {
    background: #020617;
    border: 1px solid #111827;
    border-radius: 8px;
    padding: 15px;
    height: 320px;
    overflow-y: auto;
    margin-bottom: 15px;
}

/* Mesaj baloncukları */
.msg {
    margin-bottom: 14px;
    display: flex;
    flex-direction: column;
    max-width: 75%;
}

.msg-admin {
    background: #111827;
    padding: 10px 14px;
    color: #e5e7eb;
    border-radius: 10px;
    border-left: 3px solid #3b82f6;
}

.msg-user {
    background: #3b82f6;
    padding: 10px 14px;
    color: white;
    border-radius: 10px;
    margin-left: auto;
    border-right: 3px solid #60a5fa;
}

.msg-time {
    font-size: 11px;
    opacity: 0.7;
    margin-top: 4px;
}

/* Ekler */
.attach-box img {
    max-width: 120px;
    border-radius: 6px;
    margin-right: 10px;
    margin-top: 8px;
}

/* Mesaj yazma alanı */
.send-box textarea {
    width: 100%;
    height: 80px;
    background: #020617;
    border: 1px solid #111827;
    color: #e5e7eb;
    border-radius: 6px;
    padding: 10px;
    font-size: 14px;
}

/* Alt butonlar */
.bottom-buttons{
    display:flex;
    justify-content:space-between;
    align-items:center;
    margin-top:10px;
}

/* Gönder butonu: portalın eski stili */
.bottom-buttons .btn-send{
    /* Eski stilini kullan diye sadece class bırakıyoruz */
}

/* Ticket kapat butonu */
.btn-ticket-close{
    background:#ef4444;
    color:#fff;
    border:none;
    border-radius:6px;
    padding:8px 16px;
    cursor:pointer;
    font-size:14px;
}

.btn-ticket-close:hover{
    opacity:.9;
}
</style>

<section class="section">
    <div class="ticket-page-wrap">

        <!-- ÜST BİLGİ KARTI -->
        <div class="ticket-card">
            <h3 style="margin:0;">
                Ticket #<?= $ticketId ?> — <?= htmlspecialchars($ticket['subject']) ?>
            </h3>

            <p style="margin-top:8px;">
                <strong>Durum:</strong> <?= htmlspecialchars($ticket['status']) ?><br>
                <strong>Oluşturulma:</strong> <?= $ticket['created_at'] ?><br>
                <strong>Güncelleme:</strong> <?= $ticket['updated_at'] ?>
            </p>

            <?php if (!empty($attachments)): ?>
                <div class="attach-box">
                    <strong>Ekler:</strong><br>
                    <?php foreach ($attachments as $a): ?>
                        <a href="<?= htmlspecialchars('../'.$a['file_path']) ?>" target="_blank">
                            <img src="<?= htmlspecialchars('../'.$a['file_path']) ?>" alt="">
                        </a>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- CHAT KARTI -->
        <div class="ticket-chat-card">

            <div class="chat-box">
                <?php foreach ($messages as $m): ?>
                    <?php if ($m['sender'] === 'admin'): ?>
                        <div class="msg msg-admin">
                            <?= nl2br(htmlspecialchars($m['message'])) ?>
                            <span class="msg-time"><?= $m['created_at'] ?></span>
                        </div>
                    <?php else: ?>
                        <div class="msg msg-user">
                            <?= nl2br(htmlspecialchars($m['message'])) ?>
                            <span class="msg-time"><?= $m['created_at'] ?></span>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>

                <?php if (empty($messages)): ?>
                    <p style="color:#9ca3af;">Henüz mesaj yok.</p>
                <?php endif; ?>
            </div>

            <?php if ($ticket['status'] !== 'closed'): ?>
            <!-- MESAJ GÖNDER / TİCKET KAPAT -->
            <form method="post">
                <div class="send-box">
                    <textarea name="message" placeholder="Mesajını yaz..." required></textarea>
                </div>

                <div class="bottom-buttons">
                    <button name="send_message" class="btn btn-primary btn-send">
                        Gönder
                    </button>

                    <button name="close_ticket"
                            class="btn-ticket-close"
                            onclick="return confirm('Ticket kapatılsın mı?');">
                        Ticketı Kapat
                    </button>
                </div>
            </form>
            <?php else: ?>
                <p style="color:#ef4444;margin-top:10px;">
                    Bu ticket kapatılmıştır. Yeni mesaj gönderilemez.
                </p>
            <?php endif; ?>

        </div>

    </div>
</section>
