<?php
require_once __DIR__ . '/../includes/db.php';

$db = DB::get();
$universes = $db->query("SELECT * FROM portal_universes ORDER BY id ASC")->fetchAll();

?>

<section class="section">
    <h2>Evren Listesi</h2>
    <p>Aktif ve yakında açılacak tüm Novapus evrenleri burada listeleniyor.</p>

    <div class="universe-list">

        <?php foreach ($universes as $uni): ?>
            <?php
                // Durum etiketi
                if ($uni['status'] === 'active') {
                    $badge = '<span class="badge badge-live">AKTİF</span>';
                } elseif ($uni['status'] === 'soon') {
                    $badge = '<span class="badge badge-soon">YAKINDA</span>';
                } else {
                    $badge = '<span class="badge badge-off">KAPALI</span>';
                }
            ?>

            <article class="universe-card">
                <div class="universe-header">
                    <h3><?= htmlspecialchars($uni['name']) ?></h3>
                    <?= $badge ?>
                </div>

                <p class="universe-desc">
                    <?= htmlspecialchars($uni['short_description'] ?? "Bu evren hakkında açıklama bulunmuyor.") ?>
                </p>

                <ul class="universe-features">
                    <li>Filo Hızı: x<?= htmlspecialchars($uni['speed_fleet']) ?></li>
                    <li>Ekonomi: x<?= htmlspecialchars($uni['speed_economy']) ?></li>
                    <li>Araştırma: x<?= htmlspecialchars($uni['speed_research']) ?></li>
                    <li>DF: %<?= htmlspecialchars($uni['fleet_to_debris']) ?> filo,
                        %<?= htmlspecialchars($uni['defense_to_debris']) ?> savunma</li>
                </ul>

                <div class="universe-actions">
                    <?php if ($uni['status'] === 'active'): ?>
<a href="index.php?page=play&universe=<?= $uni['id'] ?>" 
   class="btn btn-primary"
   target="_blank"
   rel="noopener noreferrer">
   Bu evrende oyna
</a>
                    <?php else: ?>
                        <button class="btn btn-disabled" disabled>Yakında açılacak</button>
                    <?php endif; ?>
                </div>

            </article>

        <?php endforeach; ?>

    </div>
</section>


