<?php

/**
 *  OPBE
 *  Copyright (C) 2013  Jstar
 *
 * This file is part of OPBE.
 *
 * OPBE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OPBE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OPBE.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package OPBE
 * @author Jstar <frascafresca@gmail.com>
 * @copyright 2013 Jstar <frascafresca@gmail.com>
 * @license http://www.gnu.org/licenses/ GNU AGPLv3 License
 * @version alpha(2013-2-4)
 * @link https://github.com/jstar88/opbe
 */
class IterableUtil implements Iterator
{

    /* Iterator functions */

    public function rewind(): void
    {
        reset($this->array);
    }

    public function current(): mixed
    {
        return current($this->array);
    }

    public function key(): mixed
    {
        return key($this->array);
    }

    #[\ReturnTypeWillChange]
    public function next()
    {
        return next($this->array);
    }

    public function valid(): bool
    {
        return $this->current() !== false;
    }

    /* other functions */
    public function getIterator()
    {
        return $this->array;
    }

}
