﻿<?php
/**
 *  2Moons
 *   by Jan-Otto Kröpke 2009-2016
 *
 * For the full copyright and license information, please view the LICENSE
 *
 * @package 2Moons
 * @author Jan-Otto Kröpke <slaver7@gmail.com>
 * @copyright 2009 Lucky
 * @copyright 2016 Jan-Otto Kröpke <slaver7@gmail.com>
 * @licence MIT
 * @version 1.8.x Koray Karakuş <koraykarakus@yahoo.com>
 * @link https://github.com/jkroepke/2Moons
 */

// Translated into English by QwataKayean . All rights reversed (C) 2012
// 2Moons - Copyright (C) 2010-2012 Slaver


$LNG['shortNames'] = array (
202 => 'Light Cargo',
203 => 'Heavy Cargo',
204 => 'Light Fighter',
205 => 'Heavy Fighter',
206 => 'Cruiser',
207 => 'Battleship',
208 => 'Colony Ship',
209 => 'Recycler',
210 => 'Spy Probe',
211 => 'Planet Bomber',
212 => 'Solar Satellite',
213 => 'Star Fighter',
214 => 'Battle Fortress',
215 => 'Battle Cruiser',
216 => 'Black Moon',
217 => 'Battle Transporter',
218 => 'Avatar',
219 => 'Battle Recycler',
220 => 'Dark Matter Collector',

401 => 'Missile Launcher',
402 => 'Light Laser Turret',
403 => 'Heavy Laser Turret',
404 => 'Gauss Cannon',
405 => 'Ion Cannon',
406 => 'Plasma Cannon',
407 => 'Small Shield Dome',
408 => 'Large Shield Dome',
409 => 'Atmospheric Shield',
410 => 'Gravitons Cannon',
411 => 'Orbital Defence Platform',
);

$LNG['bonus'] = array(
	'Attack'			=> 'Attack',
	'Defensive'			=> 'Defence',
	'Shield'			=> 'Shield',
	'BuildTime'			=> 'Construction Time',
	'ResearchTime'		=> 'Research time',
	'ShipTime'			=> 'Ship Building time',
	'DefensiveTime'		=> 'Defense Building time',
	'Resource'			=> 'Production of Resources',
	'Energy'			=> 'Production of Energy',
	'ResourceStorage'	=> 'Resource storage',
	'ShipStorage'		=> 'Ships storage',
	'FlyTime'			=> 'Flying time',
	'FleetSlots'		=> 'Fleet Slots',
	'Planets'			=> 'Planets',
	'SpyPower'			=> 'Espionage power',
	'Expedition'		=> 'Expeditions',
	'GateCoolTime'		=> 'Jump gate charging time',
	'MoreFound'			=> 'Expedition Found',
);

$LNG['tech'] = array(
  0 => 'Buildings',
  1 => 'Metal Mine',
  2 => 'Crystal Mine',
  3 => 'Deuterium Refinery',
  4 => 'Solar Power plant',
  6 => 'University',
 12 => 'Deuterium Power Plant',
 14 => 'Robot Factory',
 15 => 'Nanite Factory',
 21 => 'Shipyard',
 22 => 'Metal Storage',
 23 => 'Crystal Storage',
 24 => 'Deuterium Storage',
 31 => 'Research Lab',
 33 => 'Terraformer',
 34 => 'Alliance Depot',
 44 => 'Missile Silo',

 40 => 'Moon Buildings',
 41 => 'Moon base',
 42 => 'Phalanx Sensor',
 43 => 'Jumpgate',

100 => 'Research',
106 => 'Spy Technology',
108 => 'Computer Technology',
109 => 'Weapons Technology',
110 => 'Shield Technology',
111 => 'Armour Technology',
113 => 'Energy Technology',
114 => 'Hyperspace Technology',
115 => 'Combustion Engine',
117 => 'Impulse Engine',
118 => 'Hyperspace Engine',
120 => 'Laser Technology',
121 => 'Ion Technology',
122 => 'Plasma Technology',
123 => 'Intergalactic Research Network',
124 => 'Expedition Research',
131 => 'Mineral Research',
132 => 'Semi-Crystals Research',
133 => 'Fuel Research',
199 => 'Graviton Research',

200 => 'Ships',
202 => 'Light Cargo',
203 => 'Heavy Cargo',
204 => 'Light Fighter',
205 => 'Heavy Fighter',
206 => 'Cruiser',
207 => 'Battleship',
208 => 'Colony Ship',
209 => 'Recycler',
210 => 'Spy Probe',
211 => 'Planet Bomber',
212 => 'Solar Satellite',
213 => 'Star Fighter',
214 => 'Battle Fortress',
215 => 'Battle Cruiser',
216 => 'Black Moon',
217 => 'Battle Transporter',
218 => 'Avatar',
219 => 'Battle Recycler',
220 => 'Dark Matter Collector',

400 => 'Planetary Defense',
401 => 'Missile Launcher',
402 => 'Light Laser Turret',
403 => 'Heavy Laser Turret',
404 => 'Gauss Cannon',
405 => 'Ion Cannon',
406 => 'Plasma Cannon',
407 => 'Small Shield Dome',
408 => 'Large Shield Dome',
409 => 'Atmospheric Shield',
410 => 'Gravitons Cannon',
411 => 'Orbital Defence Platform',

500 => 'Missiles',
502 => 'Interceptor',
503 => 'Interplanetary missiles',

600 => 'Officers',
601 => 'Geologist',
602 => 'Admiral',
603 => 'Engineer',
604 => 'Technocrat',
605 => 'Constructor',
606 => 'Scientist',
607 => 'Storage expert',
608 => 'Minister of Defence',
609 => 'Guardian',
610 => 'Spy',
611 => 'Commander',
612 => 'Destroyer',
613 => 'General',
614 => 'Conqueror',
615 => 'Emperor',

	700 => 'Premium Optimizations',
	701 => 'Weapons Upgrade',
	702 => 'Shield Upgrade',
	703 => 'Building Upgrade',
	704 => 'Resource Upgrade',
	705 => 'Energy Upgrade',
	706 => 'Research Upgrade',
	707 => 'Fleet Upgrade',

	900 => 'Resources',
	901 => 'Metal',
	902 => 'Crystal',
	903 => 'Deuterium',
	911 => 'Energy',
	921 => 'Dark Matter',
);

$LNG['shortDescription'] = array(
1 => 'Used in the extraction of metal ore, metal mines are of primary importance to all emerging and established empires.',
2 => 'Crystals are the main resource used to build electronic circuits and form certain alloy compounds.',
3 => 'Deuterium is used as fuel for spaceships and is harvested in the deep sea. Deuterium is a rare substance and is thus relatively expensive.',
4 => 'Solar power plants absorb energy from solar radiation. All mines need energy to operate.',
6 => 'Shortens research time each level by 8%.',
12 => 'The fusion reactor uses deuterium to produce energy.',
14 => 'Robotic factories provide construction robots to aid in the construction of buildings. Each level increases the speed of the upgrade of buildings',
15 => 'This is the ultimate in robotics technology. Each level cuts the construction time for buildings, ships, and defenses',
21 => 'All types of ships and defensive facilities are built in the planetary shipyard',
22 => 'Provides storage for excess Metal.',
23 => 'Provides storage for excess Crystal.',
24 => 'Provides storage for excess Deuterium',
31 => 'A research lab is required in order to conduct research into new technologies.',
33 => 'The Terraformer increases the usable area on the planet. For each level of terraformer, you get 5 additional empty fields to use and an extra one every even level, one of which is taken up by the terraformer.',
34 => 'The Alliance Depot is used to supply fuel to friendly fleets in orbit.',
41 => 'The moon has no atmosphere therefore a lunar base must be built before the settlement of other buildings.',
42 => 'The sensor array allows you to monitor fleet movements. The higher the stage, the greater is the range of the phalanx.',
43 => 'Jump gates are huge transmitters that are able to send large fleets without loss of time through the universe.',
44 => 'Missile silos are used to store rockets',

106 => 'Information about other planets and moons can be gained using this technology.',
108 => 'More fleets can be commanded by increasing computer skills. Each level of computer technology increases the maximum number of fleets by one.',
109 => 'Weapons technology makes weapons systems more efficient. Each level of weapons technology increases the weapon strength of units by 10 % of the base value.',
110 => 'Shielding technology makes the shields on ships and defensive facilities more efficient. Each level of shield technology increases the strength of the shields by 10 % of the base value.',
111 => 'Special alloys improve the armour on ships and defensive structures. The effectiveness of the armour can be increased by 10 % per level.',
113 => 'The command of different types of energy is necessary for many new technologies.',
114 => 'By integrating the 4th and 5th dimensions it is now possible to research a new kind of drive that is more economical and efficient.',
115 => 'The development of this drive makes some ships faster, although each level increases speed by only 10 % of the base value.',
117 => 'The impulse drive is based on the reaction principle. Further development of this drive makes some ships faster, although each level increases speed by only 20 % of the base value.',
118 => 'Hyperspace drive warps space around a ship. The development of this drive makes some ships faster, although each level increases speed by only 30 % of the base value.',
120 => 'Focusing light produces a beam that causes damage when it strikes an object.',
121 => 'A deadly beam of accelerated ions. This causes enormous damage when striking an object.',
122 => 'A further development of ion technology which accelerates high-energy Plasma, a result of super-heating Ions. This has a devastating effect when striking an object.',
123 => 'Researchers on different planets communicate via this network.',
124 => 'With an astrophysics research module, ships can undertake long expeditions. Every second level of this technology will allow you to colonise an extra planet.',
131 => 'Increases the production of Metal by 2%',
132 => 'Increases the production of Crystal by 2%',
133 => 'Increases the production of Deuterium by 2%',
199 => 'Firing a concentrated charge of graviton particles can create an artificial gravity field, which can destroy ships or even moons.',

202 => 'The light cargo is an agile ship which can quickly transport resources to other planets.',
203 => 'This cargo ship has a much larger cargo capacity than the light cargo, and is generally faster thanks to an improved drive.',
204 => 'This is the first fighting ship all emperors will build. The light fighter is an agile ship, but it is also vulnerable. In mass numbers, these ships can become a great threat to any empire. They are the first to accompany small and large cargoes to hostile planets with minor defences.',
205 => 'This fighter is better armoured and has a higher attack strength than the light fighter.',
206 => 'Cruisers are armoured almost three times as heavily as heavy fighters and have more than twice the firepower. In addition, they are very fast.',
207 => 'Battleships form the backbone of a fleet. Their heavy cannons, high speed, and large cargo holds make them opponents to be taken seriously.',
208 => 'Vacant planets can be colonized with this ship.',
209 => 'The recycler can get raw materials from debris fields.',
210 => 'Spy probes are small agile drones, which provide data over long distances on fleets and planets.',
211 => 'The bomber was specially designed to destroy a planets defences.',
212 => 'Solar satellites are simple platforms of solar cells that are located in a high stationary orbit. They collect the sunlight and pass it on to the ground station via laser. ',
213 => 'The destroyer is the king of the warships.',
214 => 'The destructive power of the Death Star is second to none and can destroy moons.',
215 => 'The Battle Cruiser is specialized in the interception of hostile fleets.',
216 => 'The successor of the popular death star, faster but not as strong.',
217 => 'Is a development of the large cargo, it has more carry capacity and flies faster with the right techonology.',
218 => 'The absolute worst case scenario, albeit very slowly.',
219 => 'Is a huge cargo space and new engines, enable it to fly faster and gather more in debris fields .',
220 => 'After long years of research dark matter is now collectable from the moon.',

401 => 'The Rocket Launcher is a simple but cost-effective defense.',
402 => 'Light Lasers are simple ground based defense weapons. They use special targeting systems to track and attack enemy ships. They fire a high intensity laser, designed to cut through the hull of the target.',
403 => 'The Heavy Laser is an improved version of the Light Laser.',
404 => 'The Gauss Cannons fires high-density metal projectiles at extremely high velocity.',
405 => 'An ion cannon is a weapon that fires beams of ions (positively or negatively charged particles).',
406 => 'the Plasma Turret uses a large nuclear reactor fuel cell to power an electromagnetic accelerator that fires a pulse, or toroid, of plasma.',
407 => 'The Small Shield Dome envelops the whole planet in a field, which can absorb tremendous amounts of energy.',
408 => 'The development of the Large Shield Dome allows for substantially more energy to be absorbed during attacks.',
409 => 'The evolution of the Great Shield Dome Shield technology. It uses much more energy but can endur even more attacks than any other shield.',
410 => 'After years of research at the gravitational force, researchers where able to develop a Graviation cannon that generate small concentrated Gravition field that can be shoot at the enemy.',
411 => 'There is an immovable defensive platform. It has no direct power, and is held by Gravity in a stable orbit of the planet. The start of this process requires high masses of energy.',

502 => 'Interceptor missiles are used to destroy attacking Interplanetary missiles.',
503 => 'Interplanetary missiles are used to destroy the opponents defenses.',

601 => 'The Geologist is an expert in astro-mineralogy and crystalography. He assists in metallurgy and chemistry related subjects. He is in charge of optimising the use and refining of raw material throughout the empire.',
602 => 'The Admiral is an experienced veteran and a skillful strategist. Even in the hardest battles, he is able to grasp the situation and guide his subordinates. A wise emperor can always rely on his help in times of war.',
603 => 'The Engineer is a specialist in energy management. In peacetime, it increases the energy of all the colonies.',
604 => 'The guild of the Technocrats is composed of genius scientists, and you will find them always over the realm where all human logic would be defied. For thousands of years, no normal humans have ever cracked the code of a Technocrat. The Technocrat inspires the researchers of the empire with his presence.',
605 => 'The Constructor has altered their DNA, only one of these men can build an entire city in a short time.',
606 => 'Scientists are part of a guild to concurrent technocrats. They specialize in the improvement of technologies.',
607 => 'Storage is part of the ancient brotherhood of the planet Hsac. His motto is to win the maximum, which is why we need huge storage space. Thus has developed a new storage technique.',
608 => 'The Minister of Defence is a member of the Imperial Army. focus on your job allows you to build a formidable defense in a short period of time.',
609 => 'The Guardian is part of the Imperial Army and its goal is to develop technologies that improve the planetary defenses.',
610 => 'The Spy is an enigmatic person. No one ever saw his true face, the only way would be killed.',
611 => 'The Commander is part of the Imperial Army and has mastered the art of managing fleets. His brain can calculate the trajectories of a large number of fleets.',
612 => 'The Destroyer is a member of the Imperial Army without mercy. Slaughter everything that is on its way just for fun. It is currently developing nothing.',
613 => 'The General is a person who has served for many years to the Imperial Army. manufacturers produce ships faster in its presence.',
614 => 'The Conqueror is a member of the Imperial Army, it has the ability to navigate a particular type of ship that no one else could do or take off.',
615 => 'The Emperor placed under his command available to all officers in the empire, combining their skills to dominate the universe and to become an opponent almost invincible.',

701 => 'Increases the attack value of the ships and defenses.',
702 => 'Increases the value of ships shields and defenses',
703 => 'Shortens the construction time for buildings',
704 => 'Increases resource production',
705 => 'Increases energy production',
706 => 'Shortens research time',
707 => 'Shortens flying time. Does not affect Expeditions.',

901 => 'Metal is the main resource for Buildings and Ships. It is the cheapest resource, but it is needed the most as well.',
902 => 'Crystals are the main resource used to build electronic circuits and form certain alloy compounds.',
903 => 'Deuterium is found in the deepest sea. It is the most expensive resource and needs the most energy as well.',
911 => 'Energy is needed for the production of every resource.',
921 => 'Dark Matter is a very mysterious resource. Nobody really knows where it comes from. Sometimes it just appears out of nowhere.',
);

$LNG['longDescription'] = array(
1 => 'Used in the extraction of metal ore, metal mines are of primary importance to all emerging and established empires.',
2 => 'Crystals are the main resource used to build electronic circuits and form certain alloy compounds.',
3 => 'Deuterium is used as fuel for spaceships and is harvested in the deep sea. Deuterium is a rare substance and is thus relatively expensive.',
4 => 'Solar power plants absorb energy from solar radiation. All mines need energy to operate.',
6 => 'Shortens research time each level by 8%.',
12 => 'The fusion reactor uses deuterium to produce energy.The efficiency of Deuterium power plant raises according to the Energy Technology level as well as its own level. The formula for energy production is:<br>Energy produced = 30 x Deuterium Power Plant level x (1.05 + (0.01 * Energy level))^Deuterium Power Plant',
14 => 'Robotic factories provide construction robots to aid in the construction of buildings. Each level increases the speed of the upgrade of buildings',
15 => 'This is the ultimate in robotics technology. Each level cuts the construction time for buildings, ships, and defenses',
21 => 'All types of ships and defensive facilities are built in the planetary shipyard',
22 => 'Provides storage for excess Metal.',
23 => 'Provides storage for excess Crystal.',
24 => 'Provides storage for excess Deuterium',
31 => 'A research lab is required in order to conduct research into new technologies.',
33 => 'The Terraformer increases the usable area on the planet. For each level of Terraformer you get 5 additional fields to use and one extra field every even level, one field is occupied by Terraformer itself.<br>To start building Terraformer you don\'t need the energy available, you just need to be capable to produce enough energy to start the building.',
34 => 'With an Alliance Depot you can supply fuel to friendly fleets in orbit. The Alliance Depot allows you to support friendly fleets so they can remain stationed at your planet for a time. The depot can launch a support-rocket that brings deuterium to the fleet in the orbit. The amount of deuterium is 20,000 deuterium for each Alliance Depot Level.',
41 => 'The moon has no atmosphere therefore a lunar base must be built before the settlement of other buildings. Each level of Moon Base gives 3 extra fields. Once built, the Moon Base can never be deconstructed. ',
42 => 'The sensor array allows you to monitor fleet movements. The higher the stage, the greater is the range of the Phalanx. One use costs 5.000 deuterium. Note that moons cannot be scanned with Phalanx due to their lack of the atmosphere<br><br>What Sensor Phalanx can see:<li>Attacking fleets (including ACS)</li><li>Trading fleets</li><li>Fleets on deployment mission</li><li>Spying fleets<li>Fleets with the mission hold (ACS)</li><br>If you scan the home planet of the fleet:<li>Fleets coming home from any mission (except Recalled deployment)</li><li>Fleets on a hold or expedition mission</li> ',
43 => 'Jump gates are huge transmitters that are able to send large fleets without loss of time through the universe. You can\'t transfer your resources this way. There is a sixty minute cooldown time on both Jumpgates that were used.',
44 => 'Missile silos is used for storage of rockets. For each level of the missile silo an extra 10 slots are made available. An Interceptor missile occupies 1 slot, while an interplanetary missile occupies 2.',

106 => 'Information about other planets and moons can be gained using this technology. At certain levels of Spy Technologies you get more information about foreign fleets on your Overview screen:<br><br><li>At level 0-1 you just see that the fleet is approaching your planet</li><li>At levels 2-3 you can see the number of ships approaching</li><li>At levels 4-7 you can see what type of ships are in the approaching fleet</li><li>At levels 8+ you can see how many of each type of ships is in the fleet</li>',
108 => 'More fleets can be commanded by increasing computer capacities. Each level of computer technology increases the maximum number of fleets by one.',
109 => 'Weapons technology makes weapons systems more efficient. Each level of weapons technology increases the weapon strength of units by 10 % of the base value.',
110 => 'Shielding technology makes the shields on ships and defensive facilities more efficient. Each level of shield technology increases the strength of the shields by 10 % of the base value.',
111 => 'Special alloys improve the armour on ships and defensive structures. The effectiveness of the armour can be increased by 10 % per level.',
113 => 'The command of different types of energy is necessary for many new technologies. Additonally, each level of energy technology will also increase the efficiency of Deuterium Power Plant by increasing the amount of energy produced',
114 => 'By integrating the 4th and 5th dimensions it is now possible to research a new kind of drive that is more economical and efficient.',
115 => 'The development of this drive makes some ships faster, although each level increases speed by only 10 % of the base value.',
117 => 'The impulse drive is based on the reaction principle. Further development of this drive makes some ships faster, although each level increases speed by only 20 % of the base value.',
118 => 'Hyperspace drive warps space around a ship. The development of this drive makes some ships faster, although each level increases speed by only 30 % of the base value.',
120 => 'Focusing light produces a beam that causes damage when it strikes an object.',
121 => 'A deadly beam of accelerated ions. This causes enormous damage when striking an object.',
122 => 'A further development of ion technology which accelerates high-energy Plasma, a result of super-heating Ions. This has a devastating effect when striking an object.',
123 => 'Researchers on different planets communicate via this network. Each level allows one extra lab to join with the lab where you begin research, effectively adding their levels together to compute research time.',
124 => 'With an astrophysics research module, ships can undertake long expeditions. Every second level of this technology (starting from the 1st) will allow you to colonise an extra planet. You can also send more expedition in to deep space.<br><br><li>Level 1-3 - 1 expedition</li><li>Level 4-8 - 2 expeditions</li><li>Level 9-15 - 3 expeditions</li><li>Level 16-24 - 4 expeditions</li>',
131 => 'Increases the production of Metal by 2%',
132 => 'Increases the production of Crystal by 2%',
133 => 'Increases the production of Deuterium by 2%',
199 => 'Firing a concentrated charge of graviton particles can create an artificial gravity field, which can destroy ships or even moons.',

202 => 'The light cargo is an agile ship which can quickly transport resources to other planets.<br>Light cargo switches to Impusle drive at level 5, doubling its base speed',
203 => 'This cargo ship has a much larger cargo capacity than the light cargo, and is generally faster thanks to an improved drive.',
204 => 'This is the first fighting ship all emperors will build. The light fighter is an agile ship, but vulnerable on its own. In mass numbers, they can become a great threat to any empire. They are the first to accompany small and large cargoes to hostile planets with minor defences.',
205 => 'This fighter is better armoured and has a higher attack strength than the light fighter.',
206 => 'Cruisers are armoured almost three times as heavily as heavy fighters and have more than twice the firepower. In addition, they are very fast.',
207 => 'Battleships form the backbone of a fleet. Their heavy cannons, high speed, and large cargo holds make them opponents to be taken seriously.',
208 => 'Vacant planets can be colonized with this ship.',
209 => 'The recycler can get raw materials from debris fields.<br>Recycler upgrades to Impusle drive at level 17 and then to Hyperspace drive when it is at level 15',
210 => 'Spy probes are small agile drones, which provide data over long distances on fleets and planets.',
211 => 'The bomber was specially designed to destroy a planets defences.<br>Planet Bomber switches to Hyperspace drive at level 8',
212 => 'Solar satellites are simple platforms of solar cells that are located in a high stationary orbit. They collect the sunlight and pass it on to the ground station via laser. ',
213 => 'The destroyer is the king of the warships.',
214 => 'The destructive power of the Death Star is second to none and can destroy moons.',
215 => 'The Battle Cruiser is specialized in the interception of hostile fleets.',
216 => 'The successor of the popular death star, faster but not as strong.',
217 => 'Is a development of the large cargo, it has more carry capacity and flies faster with the right techonology.',
218 => 'The absolute worst case scenario, albeit very slowly.',
219 => 'Is a huge cargo space and new engines, enable it to fly faster and gather more in debris fields .',
220 => 'After long years of research dark matter is now collectable from the moon.',

401 => 'The Rocket Launcher is a simple but cost-effective defense.',
402 => 'Light Lasers are simple ground based weapons that utilize special targeting systems to track the enemy and fire a high intensity laser designed to cut through the hull of the target.',
403 => 'The Heavy Laser is a practical, improved version of the Light Laser.',
404 => 'The Gauss Cannons fires high-density metal projectiles at extremely high velocity.',
405 => 'An ion cannon is a weapon that fires beams of ions (positively or negatively charged particles).',
406 => 'the Plasma Turret uses a large nuclear reactor fuel cell to power an electromagnetic accelerator that fires a pulse, or toroid, of plasma.',
407 => 'The Small Shield Dome envelops the whole planet in a field, which can absorb tremendous amounts of energy.',
408 => 'The development of the Large Shield Dome needs substantially more energy to endur attacks.',
409 => 'The evolution of the Great Shield Dome Shield technology. It uses much more energy but can endur even more attacks than any other shield.',
410 => 'After years of research at the gravitational force, researchers where able to develop a Graviation cannon that generate small concentrated Gravition field that can be shoot at the enemy.',
411 => 'There is an immovable defensive platform. It has no direct power, and is held by Gravity in a stable orbit of the planet. The start of this process requires high masses of energy.',

502 => 'Interceptor missiles are used to destroy attacking Interplanetary missiles. 1 Interceptor missile is required to destroy 1 Interplanetary missile',
503 => 'Interplanetary missiles are used to destroy the opponents defenses. The range of Interplanetary missiles(in number of solar system) is determined by the level of your Impulse drive:<br>Range = (5 x Impusle Drive level) - 1',

601 => 'The Geologist is a expert in astro-mineralogy and crystalography. He assists his teams in metallurgy and chemistry as he also takes care of the interplanetary communications optimising the use and refining of the raw material along the empire.',
602 => 'The Admiral is an experienced veteran and a skillful strategist. The hardest battle is able to get an idea of the situation and contact their admirals subordinates. A wise emperor could rely on their help during the fighting.',
603 => 'The Engineer is a specialist in energy management. In peacetime, it increases the energy of all the colonies.',
604 => 'The guild of the Technocrats is composed of genius scientists, and you will find them always over the realm where all human logic would be defied. For thousands of years, no normal humans have ever cracked the code of a Technocrat. The Technocrat inspires the researchers of the empire with his presence.',
605 => 'The Constructor has altered their DNA, only one of these men can build an entire city in a short time.',
606 => 'Scientists are part of a guild to concurrent technocrats. They specialize in the improvement of technologies.',
607 => 'Storage is part of the ancient brotherhood of the planet Hsac. His motto is to win the maximum, which is why we need huge storage space. Thus has developed a new storage technique.',
608 => 'The Minister of Defence is a member of the Imperial Army. focus on your job allows you to build a formidable defense in a short period of time.',
609 => 'The Guardian is part of the Imperial Army and its goal is to develop technologies that improve the planetary defenses.',
610 => 'The Spy is an enigmatic person. No one ever saw his true face, the only way would be killed.',
611 => 'The Commander is part of the Imperial Army and has mastered the art of managing fleets. His brain can calculate the trajectories of a large number of fleets.',
612 => 'The Destroyer is a member of the Imperial Army without mercy. Slaughter everything that is on its way just for fun. It is currently developing nothing.',
613 => 'The General is a person who has served for many years to the Imperial Army. manufacturers produce ships faster in its presence.',
614 => 'The Conqueror is a member of the Imperial Army, it has the ability to navigate a particular type of ship that no one else could do or take off.',
615 => 'The Emperor placed under his command available to all officers in the empire, combining their skills to dominate the universe and to become an opponent almost invincible.',


701 => 'Increases the attack value of the ships and defenses.',
702 => 'Increases the value of ships shields',
703 => 'Shorten the construction time for buildings',
704 => 'Increases resource production',
705 => 'Increases energy production',
706 => 'Shortens research time',
707 => 'Shortens flying time. Does not affect Expeditions.',

901 => 'Metal is the main resource for Buildings and Ships. It is the cheapest resource, but it is needed the most as well. Producing Metal is the least energy expensive. The bigger the mines are, the deeper they dig into the earth.',
902 => 'Crystals are the main resource used to build electronic circuits and form certain alloy compounds. It gets produced in mines under the ground, where the raw material instantly is made into cicuits.',
903 => 'Deuterium is found in the deepest sea. It belongs to the rarest resources in the Universe. Because you have to get to the ground of the sea in order to get Deuterium, it is the most expensive resource.',
911 => 'Energy is needed for the production of every resource.',
921 => 'Dark Matter is a very mysterious resource. Nobody really knows where it comes from. Sometimes it just appears out of nowhere and sometimes it is even found in old ships. Some even say that it doesn\'t exist, but it has been proven otherwise. You can use Dark Matter to hire the most experienced officers in the universe.',
);
