<?php
// uni1/sso-login.php – PORTAL SSO LOGIN

define('MODE', 'SSO');               // ÖNEMLİ: common.php içindeki SSO blok bunu görüyor
require 'includes/common.php';

$token = HTTP::_GP('token', '', true);
if (empty($token)) {
    HTTP::redirectTo('index.php');
}

$DB = Database::get();

// 1) TOKENI ÇEK
$tokenRow = $DB->selectSingle(
    "SELECT game_user_id, universe_id, created_at
     FROM portal_login_tokens
     WHERE token = :token",
    [':token' => $token]
);

if (!$tokenRow) {
    HTTP::redirectTo('index.php');
}

// 2) TOKEN SÜRESİ (10 dk)
$createdAt = strtotime($tokenRow['created_at']);
if ($createdAt !== false && (TIMESTAMP - $createdAt) > 600) {
    // Tam SQL + param (senin Database::delete imzan böyle çalışıyor)
    $DB->delete(
        "DELETE FROM portal_login_tokens WHERE token = :token",
        [':token' => $token]
    );

    HTTP::redirectTo('index.php');
}

$gameUserId = (int)$tokenRow['game_user_id'];

// 3) OYUN KULLANICISINI ÇEK
$USER = $DB->selectSingle(
    "SELECT id, username, id_planet, universe, authlevel
     FROM uni1_users
     WHERE id = :uid",
    [':uid' => $gameUserId]
);

if (!$USER) {
    HTTP::redirectTo('index.php');
}

// 4) TOKEN TEK KULLANIMLIK → SİL
$DB->delete(
    "DELETE FROM portal_login_tokens WHERE token = :token",
    [':token' => $token]
);

// 5) 2MOONS OTURUMUNU OLUŞTUR (Session.class.php'ye UYGUN)
$session = Session::create();

$session->userId        = $USER['id'];
$session->planetId      = $USER['id_planet'];
$session->universe      = 1;                     // ← ZORUNLU
$session->lastActivity  = TIMESTAMP;
$session->userIpAddress = Session::getClientIp();

$_SESSION['id']         = $USER['id'];
$_SESSION['username']   = $USER['username'];
$_SESSION['planet']     = $USER['id_planet'];
$_SESSION['universe']   = 1;                     // ← ZORUNLU
$_SESSION['authlevel']  = $USER['authlevel'];
$_SESSION['lastlogin']  = TIMESTAMP;
$_SESSION['ip']         = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';


// 6) OYUN ANA SAYFASINA GÖNDER
HTTP::redirectTo('game.php?page=overview');
