{block name="content"}

<link rel="stylesheet" href="styles/resource/css/admin/market_admin.css">

<div class="admin-market-wrapper">

    <!-- SEKME BUTONLARI -->
    <div class="admin-tabs">
        <button class="admin-tab-btn active" data-tab="packages">Paketler</button>
        <button class="admin-tab-btn" data-tab="orders">Ödeme Talepleri</button>
    </div>

    <!-- ————————————————————————————————
         PAKETLER (GRID SİSTEMİ)
    ———————————————————————————————— -->
    <div class="admin-tab active" id="tab-packages">

        <div class="admin-grid">

            <!-- Yeni paket ekle kutusu -->
            <div class="admin-card add-card">
                <a href="?page=marketAdmin&mode=add" class="add-btn">＋ Yeni Paket Ekle</a>
            </div>

            {foreach $packages as $p}
            <div class="admin-card">

                <img src="styles/theme/gow/images/market/{$p.image}" class="admin-img">

                <h3>{$p.title}</h3>
                <p class="desc">{$p.description}</p>
                <p class="price">{$p.price}</p>

                <div class="admin-actions">
                    <a href="?page=marketAdmin&mode=edit&id={$p.id}" class="edit">Düzenle</a>

                    <a href="?page=marketAdmin&mode=activate&id={$p.id}" class="toggle">
                        {if $p.active == 1}Pasifleştir{else}Aktifleştir{/if}
                    </a>

                    <a href="?page=marketAdmin&mode=delete&id={$p.id}" 
                       class="delete"
                       onclick="return confirm('Silmek istediğine emin misin?');">
                       Sil
                    </a>
                </div>

            </div>
            {/foreach}

        </div>
    </div>

    <!-- ————————————————————————————————
         ÖDEME TALEPLERİ TABLOSU
    ———————————————————————————————— -->
    <div class="admin-tab" id="tab-orders">

        <table class="orders-table">
            <tr>
                <th>ID</th>
                <th>Oyuncu</th>
                <th>Paket</th>
                <th>Yöntem</th>
                <th>Tarih</th>
                <th>Durum</th>
                <th>İşlem</th>
            </tr>

            {foreach $orders as $o}
            <tr>
                <td>{$o.id}</td>
                <td>{$o.username}</td>
                <td>{$o.title}</td>
                <td>{$o.method}</td>
                <td>{$o.time|date_format:"%d.%m.%Y %H:%M"}</td>
                <td>{$o.status}</td>
                <td>
                    {if $o.status == 'pending'}
                    <a href="?page=marketAdmin&mode=approve&id={$o.id}" class="approve">Onayla</a>
                    <a href="?page=marketAdmin&mode=reject&id={$o.id}" class="reject">Reddet</a>
                    {else}
                    <span class="done">Tamamlandı</span>
                    {/if}
                </td>
            </tr>
            {/foreach}

        </table>

    </div>

</div>

<!-- JS -->
<script>
document.querySelectorAll('.admin-tab-btn').forEach(btn => {
    btn.addEventListener('click', function() {

        document.querySelectorAll('.admin-tab-btn').forEach(b => b.classList.remove('active'));
        this.classList.add('active');

        document.querySelectorAll('.admin-tab').forEach(tab => tab.classList.remove('active'));

        const id = this.getAttribute('data-tab');
        document.querySelector('#tab-' + id).classList.add('active');
    });
});
</script>

{/block}
