{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

<!-- ===== HEADER ===== -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* ===== HEADER ===== */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* ===== CARD ===== */
.nova-card{
    width: 100%;
    max-width: 850px;
    margin: 0 auto 20px;
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.22);
    border-radius: 14px;
    padding: 22px 26px;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}

/* Title */
.nova-title{
    font-size: 18px;
    font-weight: bold;
    color: #9fc5ff;
    text-align:center;
    margin-bottom:20px;
}

/* Rows */
.nova-row{
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:12px 0;
    border-bottom:1px solid rgba(120,150,255,0.15);
}
.nova-row:last-child{
    border-bottom:none;
}

/* Text */
.nova-user{
    color:#e4ebff;
    font-size:14px;
    font-weight:bold;
    text-decoration:none;
}
.nova-date{
    color:#aec6ff;
    font-size:13px;
}

/* Empty */
.nova-empty{
    text-align:center;
    color:#c7d4ff;
    padding:20px 0;
}

/* Back button */
.nova-back{
    display:block;
    text-align:center;
    background:rgba(40,50,80,0.7);
    padding:10px;
    border-radius:10px;
    border:1px solid rgba(120,150,255,0.35);
    font-weight:bold;
    color:#cfe0ff;
    transition:.2s;
    margin-top:20px;
}
.nova-back:hover{
    background:rgba(70,100,150,0.85);
    color:#fff;
}
</style>

<!-- ==== APPLY LIST CARD ==== -->
<div class="nova-card">
    <div class="nova-title">{$LNG.al_request_list}</div>

    {foreach $applyList as $applyRow}

    <div class="nova-row">
        <a class="nova-user"
           href="game.php?page=alliance&amp;mode=admin&amp;action=detailApply&amp;id={$applyRow.id}">
           {$applyRow.username}
        </a>

        <a class="nova-date"
           href="game.php?page=alliance&amp;mode=admin&amp;action=detailApply&amp;id={$applyRow.id}">
           {$applyRow.time}
        </a>
    </div>

    {foreachelse}

    <div class="nova-empty">{$LNG.al_no_requests}</div>

    {/foreach}

    <a class="nova-back" href="game.php?page=alliance">{$LNG.al_back}</a>
</div>

{/block}
