{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

<!-- ===== HEADER ===== -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* ===== HEADER TASARIM ===== */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* ===== KART ===== */
.nova-card{
    width: 100%;
    max-width: 760px;
    margin: 0 auto 20px;
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.25);
    border-radius: 14px;
    padding: 22px 26px;
    box-shadow: 0 0 12px rgba(0,0,0,0.45);
}

.nova-card-title{
    font-size: 18px;
    font-weight: bold;
    color: #9fc5ff;
    margin-bottom: 18px;
    text-align: center;
}

/* Label */
.nova-label{
    color: #c8d8ff;
    font-size: 14px;
}

/* Input */
.nova-input{
    width: 70%;
    height: 36px;
    background: rgba(20,25,40,0.85);
    border: 1px solid rgba(140,170,255,0.35);
    border-radius: 10px;
    padding: 6px 10px;
    color: #fff;
}

/* Submit */
.nova-submit{
    background: linear-gradient(90deg,#3a7bff,#5ea0ff);
    border: none;
    border-radius: 10px;
    padding: 8px 20px;
    color: #fff;
    font-weight: bold;
    cursor: pointer;
    transition: .2s;
}
.nova-submit:hover{
    transform: translateY(-2px);
    box-shadow: 0 0 8px rgba(120,150,255,0.65);
}

/* ===== SONUÇ TABLOSU ===== */
.nova-table-wrapper{
    margin-top: 20px;
    overflow-x: auto;
}

.nova-table{
    width: 100%;
    border-collapse: collapse;
}

.nova-table thead th{
    background: rgba(40,50,70,0.75);
    color: #dfe7ff;
    padding: 10px;
    font-size: 13px;
    border-bottom: 1px solid rgba(120,150,255,0.25);
}

.nova-table tbody td{
    padding: 10px;
    font-size: 13px;
    color: #dfe7ff;
    text-align: center;
    border-bottom: 1px solid rgba(120,150,255,0.18);
}

.nova-table tbody tr:hover{
    background: rgba(120,150,255,0.10);
    transition: .2s;
}

.nova-table a{
    color: #9cc4ff;
    font-weight: bold;
    text-decoration: none;
}
.nova-table a:hover{
    color: #dfe9ff;
}
</style>

<!-- ===== ARAMA FORMU ===== -->
<div class="nova-card">

    <div class="nova-card-title">{$LNG.al_find_alliances}</div>

    <form action="game.php?page=alliance&amp;mode=search" method="post">

        <div style="display:flex;gap:10px;justify-content:center;">
            <input class="nova-input" type="text" name="searchtext" value="{$searchText}">
            <input class="nova-submit" type="submit" value="{$LNG.al_find_submit}">
        </div>

        <div style="margin-top:10px;text-align:center;color:#cfd8ff;" class="fs-12">
            {$LNG.al_find_text}
        </div>

    </form>
</div>


<!-- ===== SONUÇ ===== -->
{if !empty($searchList)}

<div class="nova-card">

    <div class="nova-card-title">{$LNG.al_alliance}</div>

    <div class="nova-table-wrapper">
        <table class="nova-table">
            <thead>
                <tr>
                    <th>{$LNG.al_ally_info_tag}</th>
                    <th>{$LNG.al_ally_info_name}</th>
                    <th>{$LNG.al_ally_info_members}</th>
                </tr>
            </thead>

            <tbody>
                {foreach $searchList as $seachRow}
                <tr>
                    <td><a href="game.php?page=alliance&amp;mode=apply&amp;id={$seachRow.id}">{$seachRow.tag}</a></td>
                    <td><a href="game.php?page=alliance&amp;mode=apply&amp;id={$seachRow.id}">{$seachRow.name}</a></td>
                    <td><a href="game.php?page=alliance&amp;mode=apply&amp;id={$seachRow.id}">{$seachRow.members}</a></td>
                </tr>
                {foreachelse}
                <tr>
                    <td colspan="3">{$LNG.al_find_no_alliances}</td>
                </tr>
                {/foreach}
            </tbody>
        </table>
    </div>

</div>

{/if}

{/block}
