{block name="title" prepend}{$LNG.lm_trader}{/block}
{block name="content"}
<!-- HEADER -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/trader_header.jpg" class="page-header-img" alt="">
</div>
<style>
/* ====== NOVAPUS TRADER – STEP 2 MODERN TASARIM ====== */

.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 6px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}
.nova-trade-wrapper{
    width: 100%;
    max-width: 760px;
    margin: 0 auto;
}

.nova-card{
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.25);
    border-radius: 14px;
    padding: 20px;
    position: relative;
    box-shadow: 0 0 12px rgba(0,0,0,0.45);
}

/* Başlık */
.nova-card-title{
    font-size: 17px;
    font-weight: bold;
    color: #9fc5ff;
    margin-bottom: 18px;
    text-align: center;
}

/* Sağ üst X */
.nova-close-btn{
    position: absolute;
    right: 12px;
    top: 10px;
    width: 18px;
    height: 18px;
    border-radius: 50%;
    background: rgba(255,255,255,0.08);
    color: #fff;
    font-size: 12px;
    line-height: 18px;
    text-align: center;
    cursor: pointer;
    transition: .2s;
}
.nova-close-btn:hover{
    background: rgba(255,80,80,0.55);
}

.nova-table{
    width: 100%;
    border-collapse: collapse;
}

.nova-table th{
    text-align: center;
    padding: 10px;
    background: rgba(40,50,70,0.65);
    border-bottom: 1px solid rgba(120,150,255,0.25);
    color: #dfe7ff;
    font-size: 14px;
}

.nova-table td{
    padding: 10px 6px;
    color: #dfe7ff;
    border-bottom: 1px solid rgba(120,150,255,0.15);
}

/* Input alanları */
.trade_input, #ress{
    background: rgba(20,25,40,0.8) !important;
    border: 1px solid rgba(150,180,255,0.3) !important;
    border-radius: 8px !important;
    color: #fff !important;
    text-align: center;
    height: 32px;
}

/* Takas butonu */
.nova-submit-btn{
    background: linear-gradient(90deg,#3a7bff,#5ea0ff);
    border: none;
    border-radius: 10px;
    padding: 6px 26px;
    color: #fff;
    font-weight: bold;
    cursor: pointer;
    transition: .2s;
    font-size: 13px;
}
.nova-submit-btn:hover{
    transform: translateY(-2px);
    box-shadow: 0 0 8px rgba(130,160,255,0.65);
}
/* Tablo hücrelerini eşitliyoruz */
.nova-table td, .nova-table th {
    width: 25%;
}

/* Inputlar hücre genişliğine göre küçülsün */
.trade_input, #ress {
    width: 100% !important;
    max-width: 170px;
    margin: 0 auto;
}

</style>


<div class="nova-trade-wrapper">

    <div class="nova-card">

        <div class="nova-close-btn" onclick="window.location='game.php?page=trader'">×</div>

        <div class="nova-card-title">
            {$LNG.tr_sell} {$LNG.tech.$tradeResourceID}
        </div>

        <form id="trader" action="" method="post">
            <input type="hidden" name="mode" value="send">
            <input type="hidden" name="resource" value="{$tradeResourceID}">

            <table class="nova-table fs-12">

                <tr>
                    <th>{$LNG.tr_resource}</th>
                    <th colspan="2">{$LNG.tr_amount}</th>
                    <th>{$LNG.tr_quota_exchange}</th>
                </tr>

                <tr>
                    <td>{$LNG.tech.$tradeResourceID}</td>
                    <td>
                        <input readonly id="ress" value="0">
                    </td>
                    <td></td>
                    <td class="text-center">1</td>
                </tr>

                {foreach $tradeResources as $tradeResource}
                <tr>
                    <td>
                        {$LNG.tech[$tradeResource]}
                    </td>

                    <td class="text-center">
                        <input name="trade[{$tradeResource}]"
                               id="resource{$tradeResource}"
                               class="trade_input"
                               type="text"
                               value="0"
                               size="30"
                               data-resource="{$tradeResource}">
                    </td>

                    <td style="width:100px;" class="text-center align-middle">
                        <span id="resource{$tradeResource}Shortly"></span>
                    </td>

                    <td class="text-center">
                        {$charge[$tradeResource]}
                    </td>
                </tr>
                {/foreach}

                <tr>
                    <td colspan="4" class="text-center pt-3">
                        <input class="nova-submit-btn" type="submit" value="{$LNG.tr_exchange}">
                    </td>
                </tr>

            </table>

        </form>

    </div>

</div>

{block name="script" append}
<script type="text/javascript">
var charge = {$charge|json};
</script>
{/block}

{/block}
