<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/includes/admin_auth.php';

$db = DB::get();
$admin = $_SESSION['admin_user'];

// Anket ekleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['question'])) {
    $question = trim($_POST['question']);

    if ($question !== '') {
        $stmt = $db->prepare("INSERT INTO portal_surveys (question, created_at) VALUES (?, NOW())");
        $stmt->execute([$question]);
        header("Location: portal_surveys.php?added=1");
        exit;
    }
}

// Tüm anketleri çek
$surveys = $db->query("SELECT * FROM portal_surveys ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Novapus Admin · Anketler</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>
<body class="admin-shell">

<?php include __DIR__ . '/includes/sidebar.php'; ?>

<div class="admin-main">

<header class="admin-topbar">
    <div class="at-title">
        <h1>Portal Anketleri</h1>
        <span>Kullanıcılara gösterilecek anketleri yönetin</span>
    </div>

    <div class="at-user">
        <div class="at-user-info">
            <span class="at-user-label">Admin</span>
            <span class="at-user-name"><?= htmlspecialchars($admin['username']); ?></span>
        </div>
        <div class="at-user-avatar"><span>A</span></div>
    </div>
</header>

<main class="admin-content">

    <!-- Yeni Anket Ekleme Kartı -->
    <section class="admin-panel-card">
        <div class="apc-header">
            <h2>Yeni Anket Oluştur</h2>
            <span class="apc-sub">Kullanıcılara sorulacak yeni bir soru ekleyin</span>
        </div>

        <form method="post" class="admin-form">
            <label class="admin-label">Soru</label>
            <input type="text" name="question" class="admin-input" placeholder="Örn: En sevdiğiniz oyun modu hangisi?" required>

            <button class="btn-primary" type="submit">Oluştur</button>
        </form>
    </section>

    <!-- Anket Listesi -->
    <section class="admin-panel-card">
        <div class="apc-header">
            <h2>Mevcut Anketler</h2>
            <span class="apc-sub">Oluşturulmuş tüm anketlerin listesi</span>
        </div>

        <table class="apc-table">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Soru</th>
                    <th>Tarih</th>
                    <th>İşlem</th>
                </tr>
            </thead>

            <tbody>
            <?php if (empty($surveys)): ?>
                <tr><td colspan="4">Henüz oluşturulmuş bir anket yok.</td></tr>
            <?php else: ?>
                <?php foreach ($surveys as $s): ?>
                <tr>
                    <td><?= $s['id'] ?></td>
                    <td><?= htmlspecialchars($s['question']) ?></td>
                    <td><?= $s['created_at'] ?></td>
                    <td><a href="portal_survey_edit.php?id=<?= $s['id'] ?>" class="btn-sm">Düzenle</a></td>
                </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
        </table>

    </section>

</main>

</div>

</body>
</html>
