<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/Logger.php';

if (empty($_SESSION['admin_user'])) {
    header("Location: login.php");
    exit;
}

$db    = DB::get();
$admin = $_SESSION['admin_user'];

$message = '';
$success = '';

/* ---------------------------------------------------------
   AYAR GETİR / KAYDET
--------------------------------------------------------- */

function getSetting($key) {
    global $db;
    $stmt = $db->prepare("SELECT setting_value FROM portal_settings WHERE setting_key = ?");
    $stmt->execute([$key]);
    return $stmt->fetchColumn() ?: '';
}

function saveSetting($key, $value) {
    global $db;
    $stmt = $db->prepare("
        INSERT INTO portal_settings (setting_key, setting_value)
        VALUES (?, ?)
        ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)
    ");
    $stmt->execute([$key, $value]);
}

/* ---------------------------------------------------------
   AYAR KAYDETME
--------------------------------------------------------- */

if (isset($_POST['save_settings'])) {

    saveSetting('site_name', $_POST['site_name']);
    saveSetting('logo_url', $_POST['logo_url']);
    saveSetting('contact_email', $_POST['contact_email']);

    saveSetting('maintenance_mode', isset($_POST['maintenance_mode']) ? "1" : "0");
    saveSetting('maintenance_message', $_POST['maintenance_message']);

    saveSetting('smtp_host', $_POST['smtp_host']);
    saveSetting('smtp_user', $_POST['smtp_user']);
    saveSetting('smtp_pass', $_POST['smtp_pass']);
    saveSetting('smtp_port', $_POST['smtp_port']);
    saveSetting('smtp_secure', $_POST['smtp_secure']);

    Logger::write("admin_action", "Genel ayarlar güncellendi", $admin['id']);

    $success = "Ayarlar başarıyla kaydedildi!";
}

/* ---------------------------------------------------------
   SMTP TEST MAIL
--------------------------------------------------------- */

if (isset($_POST['send_test_mail'])) {

    $to      = getSetting('contact_email');
    $subject = "Novapus SMTP Test – Admin Panel";
    $body    = "Bu bir SMTP test mailidir.";

    $headers = "From: " . getSetting('smtp_user');

    if (@mail($to, $subject, $body, $headers)) {
        $success = "Test e-postası başarıyla gönderildi!";
        Logger::write("admin_action", "SMTP test mail gönderildi", $admin['id']);
    } else {
        $message = "Test mail gönderilemedi. SMTP ayarlarını kontrol edin.";
        Logger::write("security_fail", "SMTP test mail başarısız", $admin['id']);
    }
}

/* ---------------------------------------------------------
   VARSAYILAN AYARLAR
--------------------------------------------------------- */

$site_name           = getSetting('site_name');
$logo_url            = getSetting('logo_url');
$contact_email       = getSetting('contact_email');
$maintenance_mode    = getSetting('maintenance_mode');
$maintenance_message = getSetting('maintenance_message');

$smtp_host   = getSetting('smtp_host');
$smtp_user   = getSetting('smtp_user');
$smtp_pass   = getSetting('smtp_pass');
$smtp_port   = getSetting('smtp_port');
$smtp_secure = getSetting('smtp_secure');

?>
<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8">
<title>Novapus Admin · Ayarlar</title>
<link rel="stylesheet" href="assets/admin.css">
</head>

<body class="admin-shell">

<?php include __DIR__ . "/includes/sidebar.php"; ?>

<div class="admin-main">

<header class="admin-topbar">
    <div class="at-title">
        <h1>Genel Ayarlar</h1>
        <span>Portalın temel yapılandırma seçenekleri</span>
    </div>
</header>

<main class="admin-content">

<?php if ($success): ?>
    <div class="admin-success-box"><?= htmlspecialchars($success) ?></div>
<?php endif; ?>

<?php if ($message): ?>
    <div class="admin-error-box"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<form method="post">

    <!-- PORTAL AYARLARI -->
    <div class="admin-panel-card">
        <div class="apc-header">
            <h2>Portal Ayarları</h2>
            <span class="apc-sub">Genel görünüm ve bilgi ayarları</span>
        </div>

        <div class="settings-grid">
            <label>Portal Adı
                <input type="text" name="site_name" value="<?= htmlspecialchars($site_name) ?>">
            </label>

            <label>Logo URL
                <input type="text" name="logo_url" value="<?= htmlspecialchars($logo_url) ?>">
            </label>

            <label>İletişim E-postası
                <input type="email" name="contact_email" value="<?= htmlspecialchars($contact_email) ?>">
            </label>
        </div>
    </div>


    <!-- BAKIM MODU -->
    <div class="admin-panel-card" style="margin-top:18px;">
        <div class="apc-header">
            <h2>Bakım Modu</h2>
            <span class="apc-sub">Portal oyunculara kapatılabilir</span>
        </div>

        <label class="inline-check" style="margin-top:10px;">
            <input type="checkbox" name="maintenance_mode" <?= $maintenance_mode == "1" ? "checked" : "" ?>>
            Portalı bakım moduna al
        </label>

        <label style="margin-top:10px;">Bakım Mesajı
            <textarea name="maintenance_message" rows="2"><?= htmlspecialchars($maintenance_message) ?></textarea>
        </label>
    </div>


    <!-- SMTP -->
    <div class="admin-panel-card" style="margin-top:18px;">
        <div class="apc-header">
            <h2>SMTP Ayarları</h2>
            <span class="apc-sub">E-posta gönderim altyapısı</span>
        </div>

        <div class="settings-grid">

            <label>SMTP Host
                <input type="text" name="smtp_host" value="<?= htmlspecialchars($smtp_host) ?>">
            </label>

            <label>SMTP Kullanıcı
                <input type="text" name="smtp_user" value="<?= htmlspecialchars($smtp_user) ?>">
            </label>

            <label>SMTP Şifre
                <input type="password" name="smtp_pass" value="<?= htmlspecialchars($smtp_pass) ?>">
            </label>

            <label>SMTP Port
                <input type="number" name="smtp_port" value="<?= htmlspecialchars($smtp_port) ?>">
            </label>

            <label>SMTP Güvenlik
                <select name="smtp_secure">
                    <option value="tls" <?= $smtp_secure === 'tls' ? 'selected' : '' ?>>TLS</option>
                    <option value="ssl" <?= $smtp_secure === 'ssl' ? 'selected' : '' ?>>SSL</option>
                    <option value="" <?= $smtp_secure === '' ? 'selected' : '' ?>>Yok</option>
                </select>
            </label>

        </div>

        <button type="submit" name="send_test_mail" class="admin-btn-orange" style="margin-top:10px;">
            SMTP Test Mail Gönder
        </button>
    </div>


    <button type="submit" name="save_settings" class="admin-btn-save" style="margin-top:18px;">
        Ayarları Kaydet
    </button>

</form>

</main>
</div>

</body>
</html>
