<?php
// portal/includes/auth.php

require_once __DIR__ . '/db.php';

class Auth {

    public static function register($username, $email, $password) {
    $db = DB::get();

    // email benzersiz mi?
    $check = $db->prepare("SELECT id FROM portal_users WHERE email = ?");
    $check->execute([$email]);

    if ($check->rowCount() > 0) {
        return ['error' => 'Bu e-posta adresi zaten kayıtlı.'];
    }

    $hash = password_hash($password, PASSWORD_DEFAULT);

    $insert = $db->prepare("
        INSERT INTO portal_users (username, email, password_hash, created_at)
        VALUES (?, ?, ?, NOW())
    ");

    $insert->execute([$username, $email, $hash]);

    // Yeni kullanıcı ID'si
    $id = $db->lastInsertId();

    // Otomatik login
    $_SESSION['portal_user'] = [
        'id'       => $id,
        'username' => $username,
        'email'    => $email,
        'avatar'   => 'assets/img/default-avatar.png'
    ];

    // 🔥 EN ÖNEMLİ SATIR BURASI 🔥
    return [
        'success' => true,
        'user_id' => $id
    ];
}


    public static function login($email, $password) {
        $db = DB::get();

        $stmt = $db->prepare("SELECT * FROM portal_users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch();

        if (!$user) {
            return ['error' => 'E-posta veya şifre hatalı.'];
        }

        if (!password_verify($password, $user['password_hash'])) {
    return ['error' => 'E-posta veya şifre hatalı.'];
}

// ❗ E-posta doğrulanmamışsa giriş verme
if (isset($user['email_verified']) && (int)$user['email_verified'] === 0) {
    return ['error' => 'Bu hesap doğrulanmamış. Lütfen e-posta kutunu kontrol et!'];
}

// Başarılı giriş
$_SESSION['portal_user'] = [
    'id'       => $user['id'],
    'username' => $user['username'],
    'email'    => $user['email'],
    'avatar'   => $user['avatar']
];

        // Last login güncelle
        $db->prepare("UPDATE portal_users SET last_login = NOW() WHERE id = ?")->execute([$user['id']]);

        return ['success' => true];
    }

    public static function logout() {
        unset($_SESSION['portal_user']);
        session_destroy();
    }
}
