<?php
// portal/pages/login.php

require_once __DIR__ . '/../includes/auth.php';

// Forumdan gelen dönüş adresi
if (isset($_GET['return']) && $_GET['return'] !== '') {
    $_SESSION['login_return'] = $_GET['return'];
}


$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $email    = trim($_POST['email']);
    $password = $_POST['password'];

    $result = Auth::login($email, $password);

    if (isset($result['success'])) {

    if (!empty($_SESSION['login_return'])) {
        $go = $_SESSION['login_return'];
        unset($_SESSION['login_return']);
        header("Location: " . $go);
        exit;
    }

    header("Location: index.php?page=profile");
    exit;
} else {
        $message = $result['error'] ?? 'Giriş başarısız.';
    }
}
require __DIR__ . '/../includes/header.php';
?>


<section class="section narrow">
    <h2>Portala Giriş</h2>
    <p>Novapus portal hesabınla tüm evrenlere tek tıkla giriş yap.</p>

    <?php if (!empty($message)): ?>
        <div class="form-error"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form method="post" action="" class="form-card">

        <label class="form-label">
            E-posta
            <input type="email" name="email" class="form-input" required>
        </label>

        <label class="form-label">
            Şifre
            <input type="password" name="password" class="form-input" required>
        </label>

        <button type="submit" class="btn btn-primary w-100">Giriş Yap</button>

        <div class="form-bottom-text">
            Hesabın yok mu?
            <a href="index.php?page=register" style="color:#3bc9db;">Hemen kayıt ol</a>
        </div>
        <div style="margin-top:6px;font-size:12px;">
    <a href="index.php?page=forgot_password" style="color:#3bc9db;">
        Şifremi unuttum
    </a>
</div>

    </form>
</section>

<?php require __DIR__ . '/../includes/footer.php'; ?>
