<?php
// /portal/pages/support_list.php

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';

if (!isset($_SESSION['portal_user'])) {
    echo "<div class='panel'><p>Bu sayfayı görüntülemek için giriş yapmalısın.</p></div>";
    exit;
}

$db   = DB::get();
$user = $_SESSION['portal_user'];

// Kullanıcının tüm ticketları
$stmt = $db->prepare("
    SELECT id, subject, status, updated_at 
    FROM portal_tickets 
    WHERE user_id = ?
    ORDER BY updated_at DESC
");
$stmt->execute([$user['id']]);
$tickets = $stmt->fetchAll();

function statusBadge($status)
{
    $map = [
        'open'     => ['Açık',       '#3b82f6'],
        'answered' => ['Yanıtlandı', '#10b981'],
        'closed'   => ['Kapalı',     '#ef4444'],
    ];

    if (!isset($map[$status])) {
        return "<span class='badge badge-unknown'>Bilinmiyor</span>";
    }

    return "<span class='badge' style='background:{$map[$status][1]}'>{$map[$status][0]}</span>";
}
?>


<style>
/* Kart görüntüsü */
.ticket-card {
    background: #0f172a;
    border: 1px solid #1e293b;
    border-radius: 8px;
    padding: 18px;
    margin-bottom: 18px;
}

/* Satır listesi */
.ticket-row {
    display: grid;
    grid-template-columns: 60px 1fr 120px 150px 80px;
    padding: 12px 0;
    border-bottom: 1px solid #1e293b;
    align-items: center;
    color: #cbd5e1;
    font-size: 14px;
}

.ticket-row:last-child {
    border-bottom: none;
}

.ticket-row:hover {
    background: rgba(255,255,255,0.03);
}

/* Başlık satırı */
.ticket-head {
    font-weight: 600;
    color: #e2e8f0;
}

/* Badge */
.badge {
    padding: 4px 8px;
    color: white;
    border-radius: 6px;
    font-size: 12px;
}

.badge-unknown {
    background: #6b7280;
    padding: 4px 8px;
    border-radius: 6px;
    color: white;
    font-size: 12px;
}

/* Görüntüle butonu */
.view-btn {
    display: inline-block;
    padding: 6px 10px;
    background: #3b82f6;
    color: white;
    font-size: 12px;
    border-radius: 6px;
    text-decoration: none;
    text-align: center;
}

.view-btn:hover {
    opacity: .8;
}

/* Boş liste */
.empty-list {
    text-align: center;
    padding: 20px;
    color: #94a3b8;
}
</style>


<div class="ticket-card">

    <!-- Üst Başlık + Buton -->
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:15px;">
        <h3 style="margin:0;color:#e2e8f0;">Destek Taleplerim</h3>

        <a href="index.php?page=support" class="btn btn-primary btn-xs">
            Yeni Ticket Aç
        </a>
    </div>

    <!-- Liste Başlıkları -->
    <div class="ticket-row ticket-head">
        <div>ID</div>
        <div>Konu</div>
        <div>Durum</div>
        <div>Güncellendi</div>
        <div style="text-align:center;">İşlem</div>
    </div>

    <!-- LİSTE -->
    <?php if (empty($tickets)): ?>

        <div class="empty-list">
            Henüz bir destek talebin yok.
        </div>

    <?php else: ?>
        <?php foreach ($tickets as $t): ?>
            <div class="ticket-row">
                <div>#<?= $t['id'] ?></div>

                <div><?= htmlspecialchars($t['subject']) ?></div>

                <div><?= statusBadge($t['status']) ?></div>

                <div><?= $t['updated_at'] ?></div>

                <div style="text-align:center;">
                    <a class="view-btn"
                       href="index.php?page=support_view&id=<?= $t['id'] ?>">
                        Görüntüle
                    </a>
                </div>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>

</div>
