<?php
// /portal/pages/support_send.php

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/Logger.php';

if (!isset($_SESSION['portal_user'])) {
    die("Giriş yapmalısın.");
}

$db   = DB::get();
$user = $_SESSION['portal_user'];

$subject = trim($_POST['subject'] ?? "");
$message = trim($_POST['message'] ?? "");

if ($subject === "" || $message === "") {
    die("Konu ve mesaj boş olamaz.");
}

/* =============================================
   1) TICKET OLUŞTUR
============================================= */
$stmt = $db->prepare("
    INSERT INTO portal_tickets (user_id, email, subject, message, status, created_at, updated_at)
    VALUES (?, ?, ?, ?, 'open', NOW(), NOW())
");
$stmt->execute([
    $user['id'],
    $user['email'],
    $subject,
    $message
]);
$ticketId = $db->lastInsertId();

/* =============================================
   2) İLK MESAJI EKLE
============================================= */
$stmtMsg = $db->prepare("
    INSERT INTO portal_ticket_messages (ticket_id, sender, message, created_at)
    VALUES (?, 'user', ?, NOW())
");
$stmtMsg->execute([$ticketId, $message]);

/* =============================================
   3) EK GÖRSEL (OPSİYONEL)
============================================= */
if (!empty($_FILES['attachment']) && $_FILES['attachment']['error'] === 0) {

    $tmp  = $_FILES['attachment']['tmp_name'];
    $name = $_FILES['attachment']['name'];
    $ext  = strtolower(pathinfo($name, PATHINFO_EXTENSION));
    $size = $_FILES['attachment']['size'];

    $allowed = ['png', 'jpg', 'jpeg'];

    if (in_array($ext, $allowed) && $size < 5 * 1024 * 1024) {

        $newName = "ticket_" . $ticketId . "_" . time() . "." . $ext;
        $uploadPath = __DIR__ . "/../assets/uploads/" . $newName;

        if (move_uploaded_file($tmp, $uploadPath)) {
            $stmtAtt = $db->prepare("
                INSERT INTO portal_ticket_attachments (ticket_id, file_path, original_name, created_at)
                VALUES (?, ?, ?, NOW())
            ");
            $stmtAtt->execute([
                $ticketId,
                "assets/uploads/" . $newName,
                $name
            ]);
        }
    }
}

/* =============================================
   4) LOG KAYDI
============================================= */
Logger::write(
    "user_action",
    "Yeni ticket oluşturdu (#$ticketId) - Kullanıcı ID: {$user['id']}",
    $user['id']
);

/* =============================================
   5) BAŞARI → Destek listesine yönlendir
============================================= */
header("Location: index.php?page=support&ticket_created=1");
exit;
