<?php
/*******************************
 *  Novapus Portal Tree Viewer
 *  Güvenli Dizin Ağaç Listesi
 *******************************/

session_start();

/* === Basit Güvenlik === */
$ACCESS_PASSWORD = "novapus123"; // geçici şifre

if (!isset($_SESSION['tree_access'])) {

    if (!empty($_POST['pass'])) {
        if ($_POST['pass'] === $ACCESS_PASSWORD) {
            $_SESSION['tree_access'] = true;
            header("Location: tree.php");
            exit;
        } else {
            $err = "Hatalı şifre!";
        }
    }

    ?>
    <form method="post" style="margin:80px auto;width:300px;font-family:Arial;">
        <h3>Tree Viewer Giriş</h3>
        <p><input type="password" name="pass" placeholder="Şifre" style="width:100%;padding:8px;"></p>
        <button style="padding:8px 14px">Giriş</button>
        <?php if(!empty($err)) echo "<p style='color:red'>$err</p>"; ?>
    </form>
    <?php
    exit;
}

/* === Ağaç Fonksiyonu === */

function listTree($dir, $level = 0) {
    $ignore = ['.', '..', '.env', 'tree.php'];
    $files = scandir($dir);

    foreach ($files as $file) {
        if (in_array($file, $ignore)) continue;

        $path = $dir . '/' . $file;
        $indent = str_repeat("&nbsp;&nbsp;&nbsp;&nbsp;", $level);

        if (is_dir($path)) {
            echo "$indent 📁 <b>$file</b><br>";
            listTree($path, $level + 1);
        } else {
            echo "$indent 📄 $file<br>";
        }
    }
}

$root = __DIR__;
?>
<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8">
<title>Portal Dizin Ağacı</title>
<style>
    body { background:#0e1117; color:#d8e1ff; font-family:Consolas, monospace; padding:20px; }
    h1 { color:#79a8ff; }
    .tree-box { background:#111722; padding:20px; border-radius:10px; }
</style>
</head>

<body>
    <h1>📂 Portal Dizin Ağacı</h1>
    <div class="tree-box">
        <?php listTree($root); ?>
    </div>

    <p style="margin-top:30px;font-size:13px;color:#777;">
        Path: <?= htmlspecialchars($root) ?>
    </p>
</body>
</html>
