<?php

class ShowFleetDealerPage extends AbstractGamePage
{
    public static $requireModule = MODULE_FLEET_TRADER;

    function __construct()
    {
        parent::__construct();
    }

    public function send()
    {
        global $USER, $PLANET, $LNG, $pricelist, $resource;

        $shipID       = HTTP::_GP('shipID', 0);
        $Count        = max(0, round(HTTP::_GP('count', 0.0)));
        $selectedRate = HTTP::_GP('premium_rate', 0);

        $config        = Config::get();
        $allowedShips  = explode(',', $config->trade_allowed_ships);
        $baseCharge    = $config->trade_charge;

        // geçersiz gemi
        if(!in_array($shipID, $allowedShips)) {
            $this->printMessage($LNG['tr_exchange_error'], [
                ['label'=>$LNG['sys_back'],'url'=>'game.php?page=fleetDealer']
            ]);
        }

        // adet kontrolü
        if($PLANET[$resource[$shipID]] < $Count || $Count <= 0) {
            $this->printMessage($LNG['tr_exchange_error'], [
                ['label'=>$LNG['sys_back'],'url'=>'game.php?page=fleetDealer']
            ]);
        }

        // aktif premium oran kontrolü
        $activeRates = array_filter(array_map('intval', explode(',', $config->premium_active_rates)));
        if(!in_array($selectedRate, $activeRates)) {
            $this->printMessage("Geçersiz premium oran!", [
                ['label'=>$LNG['sys_back'],'url'=>'game.php?page=fleetDealer']
            ]);
        }

        // --- YENİ DM FORMÜLÜ (ADIM 3) ---
        // Admin panelde base_dm_cost ne girilmişse ona göre hesaplanır
        $baseDM = $config->base_dm_cost;

        // tek gemi için DM maliyeti:
        // örn: base %30 ise baseDM=2500 → %90 premium → 2500 * (90 / 30) = 7500 DM
        $dmCostSingle = ceil(($selectedRate / $baseCharge) * $baseDM);

        // toplam maliyet
        $dmCost = $dmCostSingle * $Count;

        // DM yeterli mi?
        if($USER[$resource[921]] < $dmCost) {
            $this->printMessage("Yeterli Karanlık Madde yok!", [
                ['label'=>$LNG['sys_back'],'url'=>'game.php?page=fleetDealer']
            ]);
        }

        // premium oran → üretim oranı
        $rateFactor = $selectedRate / 100;

        // kaynak kazançları
        $PLANET[$resource[901]] += $Count * $pricelist[$shipID]['cost'][901] * $rateFactor;
        $PLANET[$resource[902]] += $Count * $pricelist[$shipID]['cost'][902] * $rateFactor;
        $PLANET[$resource[903]] += $Count * $pricelist[$shipID]['cost'][903] * $rateFactor;

        // DM düş
        if($dmCost > 0) {
            $USER[$resource[921]] -= $dmCost;
        }

        // gemiyi düş
        $PLANET[$resource[$shipID]] -= $Count;

        Database::get()->update(
            "UPDATE %%PLANETS%% SET ".$resource[$shipID]." = ".$resource[$shipID]." - :count WHERE id = :planetID;",
            [':count'=>$Count, ':planetID'=>$PLANET['id']]
        );

        $this->printMessage(
            "İşlem başarıyla tamamlandı!",
            [['label'=>$LNG['sys_forward'], 'url'=>'game.php?page=fleetDealer']]
        );
    }


    public function show()
    {
        global $PLANET, $LNG, $pricelist, $resource, $reslist;

        $config = Config::get();
        $allowedShips = explode(',', $config->trade_allowed_ships);

        $Cost = array();
        foreach($allowedShips as $shipID)
        {
            if(in_array($shipID, $reslist['fleet']) || in_array($shipID, $reslist['defense']))
            {
                $Cost[$shipID] = array(
                    $PLANET[$resource[$shipID]],
                    $LNG['tech'][$shipID],
                    $pricelist[$shipID]['cost']
                );
            }
        }

        if(empty($Cost))
        {
            $this->printMessage(
                $LNG['ft_empty'],
                [['label'=>$LNG['sys_back'], 'url'=>'game.php?page=fleetDealer']]
            );
        }

        // premium oranları
        $activeRates = array_filter(array_map('intval', explode(',', $config->premium_active_rates)));
        if(empty($activeRates))
            $activeRates = array($config->trade_charge);

        $this->assign(array(
            'shipIDs'            => $allowedShips,
            'CostInfos'          => $Cost,
            'Charge'             => $config->trade_charge,
            'ActivePremiumRates' => $activeRates,
            'BaseDM'             => $config->base_dm_cost,   // ADIM 3 EKLENDİ
        ));

        $this->display('page.fleetDealer.default.tpl');
    }
}
