<?php
if (!defined('MODE')) {
    define('MODE', 'SSO');
}

require_once __DIR__ . '/includes/common.php';

// DB ve tablo alias
$db = Database::get();
$tables = $db->getDbTableNames();
foreach ($tables['keys'] as $i => $key) {
    define(substr($key, 2, -2), $tables['names'][$i]);
}

// Token
$token = HTTP::_GP('token', '', true);
if (!$token) {
    HTTP::redirectTo('index.php');
    exit;
}

// Token kaydı
$row = $db->selectSingle(
    "SELECT game_user_id, universe_id, created_at
     FROM portal_login_tokens
     WHERE token = :t",
    [':t' => $token]
);

if (!$row) {
    HTTP::redirectTo('index.php');
    exit;
}

// Süre kontrolü
if (TIMESTAMP - strtotime($row['created_at']) > 600) {
    $db->delete("DELETE FROM portal_login_tokens WHERE token = :t", [':t' => $token]);
    HTTP::redirectTo('index.php');
    exit;
}

$userId     = (int)$row['game_user_id'];
$universeId = (int)$row['universe_id'];

$userTable = "uni{$universeId}_users";

// Kullanıcı
$USER = $db->selectSingle(
    "SELECT id, username, id_planet, authlevel, universe
     FROM {$userTable}
     WHERE id = :id",
    [':id' => $userId]
);

if (!$USER) {
    HTTP::redirectTo('index.php');
    exit;
}

// Token tek kullanımlık
$db->delete("DELETE FROM portal_login_tokens WHERE token = :t", [':t' => $token]);

// ✅ Önce PHP session içine gerekli değerleri yaz
$_SESSION['universe']  = $universeId;     // Universe.class.php bunu okuyabiliyor (biz ekledik)
$_SESSION['id']        = (int)$USER['id'];
$_SESSION['username']  = (string)$USER['username'];
$_SESSION['planet']    = (int)$USER['id_planet'];
$_SESSION['authlevel'] = (int)$USER['authlevel'];
$_SESSION['lastlogin'] = TIMESTAMP;

// ✅ uni cookie (Universe seçimi için)
setcookie('uni', (string)$universeId, time() + 86400 * 30, '/', null, HTTPS, true);

// 🔥 SESSION OLUŞTUR
$session = Session::load();
if (!$session) {
    $session = Session::create();
}

$session->userId   = (int)$USER['id'];
$session->planetId = (int)$USER['id_planet'];
$session->universe = $universeId;

// Save => hem DB %%SESSION%% hem de $_SESSION['obj'] yazılır
$session->save();

// 🚀 OYUNA GİR
header('Location: /game.php?page=overview');
exit;
