{block name="content"}

<div class="container mt-4">

    <h2 class="mb-4 text-center fw-bold text-warning">Subay Düzenle</h2>

    <form action="admin.php?page=officers&mode=saveEdit" method="post">
        <input type="hidden" name="id" value="{$officer.id}">

        <div class="row">

            <!-- SOL BLOK -->
            <div class="col-md-6">
                <div class="card mb-3 shadow-sm">
                    <div class="card-header bg-warning text-dark fw-bold">
                        Subay Temel Bilgileri
                    </div>

                    <div class="card-body">

                        <div class="mb-3">
                            <label class="form-label fw-bold">Subay Adı</label>
                            <input type="text" name="name" class="form-control" value="{$officer.name}" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Açıklama</label>
                            <textarea name="description" class="form-control" rows="4">{$officer.description}</textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Resim Adı</label>
                            <input type="text" name="image" class="form-control" value="{$officer.image}">
                            <small class="text-muted">
                                Resimler: <b>styles/theme/gow/img/officers/</b>
                            </small>
                        </div>

                    </div>
                </div>
            </div>

            <!-- SAĞ BLOK -->
            <div class="col-md-6">
                <div class="card mb-3 shadow-sm">
                    <div class="card-header bg-success text-white fw-bold">
                        Fiyat & Süre Ayarları
                    </div>

                    <div class="card-body">

                        <div class="mb-3">
                            <label class="form-label fw-bold">Dark Matter Ücreti</label>
                            <input type="number" name="cost_dm" class="form-control" value="{$officer.cost_dm}" required>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Süre (Saat)</label>
                            <select name="duration_hours" class="form-control">
                                <option value="168"  {if $officer.duration_hours == 168}selected{/if}>7 Gün</option>
                                <option value="720"  {if $officer.duration_hours == 720}selected{/if}>30 Gün</option>
                                <option value="2160" {if $officer.duration_hours == 2160}selected{/if}>90 Gün</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">Aktif/Pasif</label>
                            <select name="active" class="form-control">
                                <option value="1" {if $officer.active == 1}selected{/if}>Aktif</option>
                                <option value="0" {if $officer.active == 0}selected{/if}>Pasif</option>
                            </select>
                        </div>

                    </div>
                </div>
            </div>

        </div>


        <!-- BONUS TABLOSU -->
        <div class="card mt-5 shadow-sm">
            <div class="card-header bg-info text-white fw-bold">
                Subay Bonusları
            </div>

            <div class="card-body">

                <style>
                    .bonus-row {
                        border: 1px solid #d6e4ff;
                        padding: 12px;
                        border-radius: 6px;
                        margin-bottom: 12px;
                        background: #f7faff;
                    }
                    .bonus-key {
                        font-size: 14px;
                        font-weight: 700;
                        color: #1a3d7c;
                    }
                    .bonus-desc {
                        font-size: 12px;
                        color: #6f7e95;
                        margin-top: -3px;
                        margin-bottom: 8px;
                    }
                </style>

                {foreach $BONUS_KEYS as $key => $desc}

                <div class="bonus-row row">

                    <div class="col-md-6">
                        <div class="bonus-key">{$key}</div>
                        <div class="bonus-desc">{$desc}</div>
                    </div>

                    <div class="col-md-4">
                        <input type="number"
                               step="0.01"
                               name="bonus_value[{$key}]"
                               class="form-control"
                               placeholder="ör: 0.10"
                               value="{if isset($effects[$key])}{$effects[$key].effect_value}{/if}">
                    </div>

                    <div class="col-md-2 d-flex align-items-center">
                        {if isset($effects[$key])}
                            <input type="checkbox" name="bonus_delete[{$key}]" class="form-check-input me-2">
                            <span>Sil</span>
                        {/if}
                    </div>

                </div>

                {/foreach}

            </div>
        </div>


        <!-- YENİ BONUS EKLE -->
        <div class="card mt-4 mb-5 shadow-sm">
            <div class="card-header bg-primary text-white fw-bold">
                Yeni Bonus Ekle
            </div>

            <div class="card-body">

                <div id="newBonusArea"></div>

                <button type="button" onclick="addBonusRow();" class="btn btn-success fw-bold mb-3">
                    + Bonus Alanı Ekle
                </button>

            </div>
        </div>

        <div class="text-center mt-3 mb-5">
            <button class="btn btn-warning btn-lg fw-bold px-5" type="submit">
                ✔ Subayı Güncelle
            </button>
        </div>

    </form>

</div>


<script>
function addBonusRow() {
    let html = `
        <div class="row mb-3">
            <div class="col-md-5">
                <input type="text" name="new_bonus_key[]" class="form-control" placeholder="ör: mine_metal">
            </div>
            <div class="col-md-5">
                <input type="number" step="0.01" name="new_bonus_value[]" class="form-control" placeholder="ör: 0.10">
            </div>
            <div class="col-md-2 d-flex align-items-center">
                <span class="text-danger fw-bold">Yeni</span>
            </div>
        </div>`;
    document.getElementById('newBonusArea').insertAdjacentHTML('beforeend', html);
}
</script>

{/block}
