{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

{$countRank = count($availableRanks)}

<!-- ================= HEADER ================= -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* Header */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 30px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow:0 0 12px rgba(0,0,0,.45);
}
.page-header-img{ width:100%; height:100%; object-fit:cover; }

/* Card */
.nova-card{
    width:100%;
    max-width:1050px;
    margin:0 auto 25px;
    background:rgba(22,28,44,0.55);
    backdrop-filter:blur(8px);
    border:1px solid rgba(120,150,255,0.22);
    border-radius:14px;
    padding:22px 26px;
    box-shadow:0 0 12px rgba(0,0,0,.45);
}

.nova-title{
    text-align:center;
    font-size:20px;
    font-weight:bold;
    color:#9fc5ff;
    margin-bottom:18px;
}

/* Table styling */
.nova-table{
    width:100%;
    border-collapse:separate;
    border-spacing:0 6px;
}

.nova-table th{
    background:rgba(40,50,80,0.7);
    color:#dce6ff;
    padding:10px 6px;
    text-align:center;
    font-size:13px;
    border-radius:8px;
}

.nova-row{
    background:rgba(10,14,28,0.55);
    border:1px solid rgba(120,150,255,0.15);
    border-radius:10px;
    transition:.2s;
}

.nova-row:hover{
    background:rgba(40,50,80,0.65);
}

.nova-table td{
    padding:10px 6px;
    color:#e5ecff;
    font-size:12px;
    text-align:center;
}

.nova-input{
    width:100%;
    padding:6px 8px;
    border-radius:10px;
    background:rgba(12,15,28,0.7);
    border:1px solid rgba(120,150,255,0.25);
    color:#fff;
}
.nova-input:focus{
    outline:none;
    border-color:#5fa6ff;
}

/* + Button */
.nova-add-btn{
    background:#3a7bff;
    color:white;
    border:none;
    padding:3px 8px;
    border-radius:6px;
    cursor:pointer;
    font-weight:bold;
}
.nova-add-btn:hover{
    background:#5fa6ff;
}

/* Delete rank */
.nova-del{
    display:inline-flex;
    align-items:center;
    justify-content:center;
    width:22px;
    height:22px;
    border-radius:6px;
    background:rgba(180,40,40,0.85);
    transition:.2s;
}
.nova-del:hover{ background:#d94a4a; }

/* Save button */
.nova-save{
    background:#3a7bff;
    border:none;
    padding:10px 14px;
    border-radius:10px;
    color:white;
    font-weight:bold;
    cursor:pointer;
}
.nova-save:hover{
    background:#5fa6ff;
}

/* Back button */
.nova-back{
    display:block;
    margin-top:15px;
    text-align:center;
    padding:10px;
    border-radius:10px;
    background:rgba(50,60,90,0.65);
    color:#dae4ff;
    border:1px solid rgba(120,150,255,0.22);
    font-weight:bold;
}
.nova-back:hover{
    background:rgba(70,100,150,0.85);
    color:white;
}
</style>


<div class="nova-card">
    <div class="nova-title">{$LNG.al_configura_ranks}</div>

<form action="game.php?page=alliance&amp;mode=admin&amp;action=permissionsSend" method="post">
<input type="hidden" name="send" value="1">

<table class="nova-table">

    <!-- HEADER -->
    <tr>
        <th colspan="{$countRank + 2}">
            {$LNG.al_configura_ranks}
            <button id="create_new_alliance_rank" class="nova-add-btn" style="float:right;">+</button>
        </th>
    </tr>

    <!-- Column titles -->
    <tr>
        <td>{$LNG.al_dlte}</td>
        <td>{$LNG.al_rank_name}</td>

        {foreach $availableRanks as $rankName}
            <td>
                <img src="styles/resource/images/alliance/{$rankName}.png" width="18" height="18">
            </td>
        {/foreach}
    </tr>

    <!-- ROWS -->
    {foreach $rankList as $rowId => $rankRow}
    <tr class="nova-row">

        <!-- Delete -->
        <td>
            <a href="game.php?page=alliance&amp;mode=admin&amp;action=permissionsSend&amp;deleteRank={$rowId}"
               class="nova-del">
                <img src="styles/resource/images/alliance/CLOSE.png" width="14">
            </a>
        </td>

        <!-- Rank name -->
        <td>
            <input type="text" name="rank[{$rowId}][rankName]"
                   value="{$rankRow.rankName}" class="nova-input">
        </td>

        <!-- Permissions matrix -->
        {foreach $availableRanks as $rankId => $rankName}
        <td>
            <input type="checkbox"
                   name="rank[{$rowId}][{$rankId}]"
                   value="1"
                   {if $rankRow[$rankName]} checked{/if}
                   {if !$ownRights[$rankName]} disabled{/if}>
        </td>
        {/foreach}

    </tr>

    {foreachelse}
    <tr>
        <td colspan="{$countRank + 2}" style="padding:20px;text-align:center;">
            {$LNG.al_no_ranks_defined}
        </td>
    </tr>
    {/foreach}

    <!-- SAVE -->
    <tr>
        <td colspan="{$countRank + 2}" style="text-align:center;padding-top:18px;">
            <input type="submit" class="nova-save" value="{$LNG.al_save}">
        </td>
    </tr>

    <!-- LEGEND -->
    <tr>
        <th colspan="{$countRank + 2}" class="mt-3">{$LNG.gl_legend}</th>
    </tr>

    {foreach $availableRanks as $rankName}
    <tr class="nova-row">
        <td><img src="styles/resource/images/alliance/{$rankName}.png" width="16"></td>
        <td colspan="{$countRank + 1}">{$LNG.al_rank_desc[$rankName]}</td>
    </tr>
    {/foreach}

    <!-- BACK -->
    <tr>
        <td colspan="{$countRank + 2}">
            <a class="nova-back" href="game.php?page=alliance&amp;mode=admin">{$LNG.al_back}</a>
        </td>
    </tr>

</table>

</form>
</div>

<!-- ==================== POPUP: CREATE NEW RANK ==================== -->

<div id="new_alliance_rank" title="{$LNG.al_create_new_rank}" style="display:none;">

<form action="game.php?page=alliance&amp;mode=admin&amp;action=permissionsSend" method="post">

<table class="nova-table">

    <tr>
        <td><label for="rankName">{$LNG.al_rank_name}:</label></td>
        <td><input type="text" class="nova-input" name="newrank[rankName]" maxlength="32" required></td>
    </tr>

    <tr><td colspan="{$countRank + 2}">&nbsp;</td></tr>

    {foreach $availableRanks as $rankId => $rankName}
    <tr>
        <td>
            <img src="styles/resource/images/alliance/{$rankName}.png" width="16">
            &nbsp;{$LNG.al_rank_desc[$rankName]}
        </td>
        <td>
            <input type="checkbox" name="newrank[{$rankId}]" value="1">
        </td>
    </tr>
    {/foreach}

    <tr>
        <td colspan="{$countRank + 2}" style="text-align:center;padding-top:10px;">
            <input type="submit" class="nova-save" value="{$LNG.al_create}">
        </td>
    </tr>

</table>

</form>

</div>

{/block}
