{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

<!-- ===== HEADER ===== -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* ===== HEADER ===== */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* ===== ANA KART ===== */
.nova-card{
    width: 100%;
    max-width: 880px;
    margin: 0 auto 20px;
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.25);
    border-radius: 14px;
    padding: 22px 26px;
    box-shadow: 0 0 12px rgba(0,0,0,0.45);
}

/* Başlık */
.nova-card-title{
    font-size: 18px;
    font-weight: bold;
    color: #9fc5ff;
    margin-bottom: 18px;
    text-align: center;
}

/* Grid */
.nova-grid{
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 12px 25px;
    margin-top: 10px;
}

.nova-label{
    color: #c8d8ff;
    font-size: 13px;
    font-weight: bold;
}
.nova-value{
    color: #9cc4ff;
    font-size: 13px;
    font-weight: bold;
}

/* Butonlar */
.nova-btn{
    width: 100%;
    background: rgba(40,50,80,0.6);
    border: 1px solid rgba(120,150,255,0.35);
    border-radius: 10px;
    padding: 8px;
    color: #dfe8ff;
    font-weight: bold;
    font-size: 13px;
    text-decoration: none;
    display: block;
    text-align: center;
    transition: .2s;
}
.nova-btn:hover{
    background: rgba(70,100,150,0.7);
    color: #fff;
    transform: translateY(-3px);
    box-shadow: 0 0 12px rgba(120,150,255,0.55);
}

/* Açıklama alanları */
.nova-box{
    background: rgba(20,27,44,0.55);
    border-radius: 10px;
    padding: 14px;
    border: 1px solid rgba(130,150,220,0.25);
    margin-top: 10px;
    color: #e4e9ff;
    font-size: 13px;
}

/* Diplomasi bölüm başlığı */
.nova-sub-title{
    font-size: 15px;
    font-weight: bold;
    margin-top: 25px;
    color: #9fc5ff;
}
</style>

<div class="nova-card">

    <div class="nova-card-title">{$LNG.al_your_ally}</div>

    {if $ally_image}
    <div style="text-align:center;margin-bottom:20px;">
        <img src="{$ally_image}" style="max-width:100%;border-radius:10px;">
    </div>
    {/if}

    <!-- GRID: Genel Bilgiler -->
    <div class="nova-grid">
        <div class="nova-label">{$LNG.al_ally_info_tag}</div>
        <div class="nova-value">{$ally_tag}</div>

        <div class="nova-label">{$LNG.al_ally_info_name}</div>
        <div class="nova-value">{$ally_name}</div>

        <div class="nova-label">{$LNG.al_ally_info_members}</div>
        <div class="nova-value">[{$ally_members} / {$ally_max_members}]</div>

        <div class="nova-label">{$LNG.al_rank}</div>
        <div class="nova-value">{$rankName}</div>
    </div>

    <br>

    <!-- Butonlar -->
    {if $rights.MEMBERLIST}
        <a class="nova-btn" href="?page=alliance&amp;mode=memberList">{$LNG.al_user_list}</a>
    {/if}

    {if $rights.ADMIN}
        <a class="nova-btn" href="?page=alliance&amp;mode=admin">{$LNG.al_manage_alliance}</a>
    {/if}

    {if isModuleAvailable($smarty.const.MODULE_CHAT)}
        <a class="nova-btn" href="#" onclick="return Dialog.AllianceChat();">{$LNG.al_goto_chat}</a>
    {/if}

    {if $rights.SEEAPPLY}
        <a class="nova-btn" href="?page=alliance&amp;mode=admin&amp;action=mangeApply">{$requests}</a>
    {/if}

    {if $rights.ROUNDMAIL}
        <a class="nova-btn" href="game.php?page=alliance&mode=circular" onclick="return Dialog.open(this.href,650,300);">
            {$LNG.al_send_circular_message}
        </a>
    {/if}

    {if $rights.EVENTS}
    <div class="nova-sub-title">{$LNG.al_events}</div>
    <div class="nova-box">
        {if $ally_events}
            {foreach $ally_events as $member => $events}
                <div><b>{$member}</b></div>
                {foreach $events as $index => $fleet}
                <div>
                    <span id="fleettime_{$index}">-</span> — {$fleet.text}
                </div>
                {/foreach}
                <br>
            {/foreach}
        {else}
            {$LNG.al_no_events}
        {/if}
    </div>
    {/if}

    <!-- Açıklama -->
    <div class="nova-sub-title">{$LNG.al_description_message}</div>
    <div class="nova-box">
        {if $ally_description}{$ally_description}{else}{$LNG.al_description_message}{/if}
    </div>

    {if $ally_web}
    <div class="nova-sub-title">{$LNG.al_web_text}</div>
    <div class="nova-box">
        <a href="{$ally_web}" target="_blank" style="color:#9dc9ff;">{$ally_web}</a>
    </div>
    {/if}

    <div class="nova-sub-title">{$LNG.al_inside_section}</div>
    <div class="nova-box">{$ally_text}</div>

    <div class="nova-sub-title">{$LNG.al_diplo}</div>
    <div class="nova-box">
        {if $DiploInfo}
            {if !empty($DiploInfo.0)}<b><u>{$LNG.al_diplo_level.0}</u></b><br>{foreach item=PaktInfo from=$DiploInfo.0}<a href="?page=alliance&mode=info&amp;id={$PaktInfo.1}">{$PaktInfo.0}</a><br>{/foreach}<br>{/if}
            {if !empty($DiploInfo.1)}<b><u>{$LNG.al_diplo_level.1}</u></b><br>{foreach item=PaktInfo from=$DiploInfo.1}<a href="?page=alliance&mode=info&amp;id={$PaktInfo.1}">{$PaktInfo.0}</a><br>{/foreach}<br>{/if}
            {if !empty($DiploInfo.2)}<b><u>{$LNG.al_diplo_level.2}</u></b><br>{foreach item=PaktInfo from=$DiploInfo.2}<a href="?page=alliance&mode=info&amp;id={$PaktInfo.1}">{$PaktInfo.0}</a><br>{/foreach}<br>{/if}
            {if !empty($DiploInfo.3)}<b><u>{$LNG.al_diplo_level.3}</u></b><br>{foreach item=PaktInfo from=$DiploInfo.3}<a href="?page=alliance&mode=info&amp;id={$PaktInfo.1}">{$PaktInfo.0}</a><br>{/foreach}<br>{/if}
            {if !empty($DiploInfo.4)}<b><u>{$LNG.al_diplo_level.4}</u></b><br>{foreach item=PaktInfo from=$DiploInfo.4}<a href="?page=alliance&mode=info&amp;id={$PaktInfo.1}">{$PaktInfo.0}</a><br>{/foreach}{/if}
        {else}
            {$LNG.al_no_diplo}
        {/if}
    </div>

    <div class="nova-sub-title">{$LNG.pl_fightstats}</div>

    <div class="nova-box">
        <div><b>{$LNG.pl_totalfight}:</b> {$totalfight|number}</div>
        <div><b>{$LNG.pl_fightwon}:</b> {$fightwon|number} {if $totalfight}({round($fightwon/$totalfight*100,2)}%){/if}</div>
        <div><b>{$LNG.pl_fightlose}:</b> {$fightlose|number} {if $totalfight}({round($fightlose/$totalfight*100,2)}%){/if}</div>
        <div><b>{$LNG.pl_fightdraw}:</b> {$fightdraw|number} {if $totalfight}({round($fightdraw/$totalfight*100,2)}%){/if}</div>
        <div><b>{$LNG.pl_unitsshot}:</b> {$unitsshot}</div>
        <div><b>{$LNG.pl_unitslose}:</b> {$unitslose}</div>
        <div><b>{$LNG.pl_dermetal}:</b> {$dermetal}</div>
        <div><b>{$LNG.pl_dercrystal}:</b> {$dercrystal}</div>
    </div>

</div>

{if !$isOwner}
<div class="nova-card">
    <div class="nova-card-title">{$LNG.al_leave_alliance}</div>
    <a href="game.php?page=alliance&amp;mode=close" onclick="return confirm('{$LNG.al_leave_ally}');">
        <button class="btn btn-danger w-100 fw-bold">{$LNG.al_continue}</button>
    </a>
</div>
{/if}

{/block}
